/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Constraint;
import charlie.smt.Falsehood;
import charlie.smt.NBVar;
import charlie.smt.SmtEvaluationException;
import charlie.smt.Truth;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class BVar
extends Constraint {
    private int _index;
    private String _name;

    BVar(int i) {
        this._index = i;
        this._name = "b" + this._index;
        this._simplified = true;
    }

    BVar(int i, String name) {
        this._index = i;
        this._name = "[" + name + "]";
        this._simplified = true;
    }

    public int queryIndex() {
        return this._index;
    }

    public String queryName() {
        return this._name;
    }

    @Override
    public NBVar negate() {
        return new NBVar(this);
    }

    @Override
    public boolean evaluate(Valuation val) {
        if (val == null) {
            throw new SmtEvaluationException(this);
        }
        return val.queryBoolAssignment(this._index);
    }

    @Override
    public BVar simplify() {
        return this;
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("b" + this._index);
    }

    @Override
    public int compareTo(Constraint other) {
        Constraint constraint = other;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Falsehood.class, Truth.class, BVar.class, NBVar.class}, (Object)constraint2, n)) {
            case 0 -> {
                Falsehood f = (Falsehood)constraint2;
                yield 1;
            }
            case 1 -> {
                Truth t = (Truth)constraint2;
                yield 1;
            }
            case 2 -> {
                BVar x = (BVar)constraint2;
                yield this._index - x._index;
            }
            case 3 -> {
                NBVar x = (NBVar)constraint2;
                int ret = this._index - x.queryIndex();
                if (ret == 0) {
                    yield -1;
                }
                yield ret;
            }
            default -> -1;
        };
    }

    public int hashCode() {
        return 17 * this._index;
    }
}

