/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.IValue;
import charlie.smt.IntegerExpression;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class CMult
extends IntegerExpression {
    private int _constant;
    private IntegerExpression _main;

    CMult(int k, IntegerExpression e) {
        this._constant = k;
        this._main = e;
        if (this._main.isSimplified() && !(this._main instanceof IValue) && !(this._main instanceof CMult) && !(this._main instanceof Addition) && this._constant != 0 && this._constant != 1) {
            this._simplified = true;
        }
    }

    public int queryConstant() {
        return this._constant;
    }

    public IntegerExpression queryChild() {
        return this._main;
    }

    @Override
    public int evaluate(Valuation val) {
        return this._constant * this._main.evaluate(val);
    }

    @Override
    public IntegerExpression simplify() {
        if (this._simplified) {
            return this;
        }
        if (this._constant == 0) {
            return new IValue(0);
        }
        if (this._constant == 1) {
            return this._main.simplify();
        }
        return this._main.simplify().multiply(this._constant);
    }

    @Override
    public IntegerExpression multiply(int constant) {
        int newconstant = this._constant * constant;
        if (newconstant == 0) {
            return new IValue(0);
        }
        if (newconstant == 1) {
            return this._main;
        }
        if (constant == 1) {
            return this;
        }
        return new CMult(newconstant, this._main);
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        if (this._constant == -1) {
            builder.append("(- ");
        } else if (this._constant < 0) {
            builder.append("(* (- " + -this._constant + ") ");
        } else {
            builder.append("(* " + this._constant + " ");
        }
        this._main.addToSmtString(builder);
        builder.append(")");
    }

    @Override
    public int compareTo(IntegerExpression other) {
        IntegerExpression integerExpression = other;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, CMult.class}, (Object)integerExpression2, n)) {
            case 0 -> {
                IValue v = (IValue)integerExpression2;
                yield 1;
            }
            case 1 -> {
                CMult cm = (CMult)integerExpression2;
                int c = this._main.compareTo(cm.queryChild());
                if (c != 0) {
                    yield c;
                }
                yield this._constant - cm.queryConstant();
            }
            default -> this._main.compareTo(other) >= 0 ? 1 : -1;
        };
    }

    public int hashCode() {
        return 2 + 7 * (this._main.hashCode() * 5 + this._constant);
    }
}

