/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.BVar;
import charlie.smt.CMult;
import charlie.smt.Conjunction;
import charlie.smt.Constraint;
import charlie.smt.Disjunction;
import charlie.smt.EqS;
import charlie.smt.Falsehood;
import charlie.smt.Geq0;
import charlie.smt.IValue;
import charlie.smt.Iff;
import charlie.smt.IntegerExpression;
import charlie.smt.Is0;
import charlie.smt.Junction;
import charlie.smt.Multiplication;
import charlie.smt.NBVar;
import charlie.smt.Neq0;
import charlie.smt.Truth;
import charlie.smt.UneqS;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;

abstract sealed class Comparison
extends Constraint
permits Geq0, Is0, Neq0 {
    protected IntegerExpression _expr;

    protected abstract boolean evaluate(int var1);

    protected abstract String symbol();

    @Override
    public abstract Constraint negate();

    protected Comparison(IntegerExpression expr) {
        this._expr = expr;
        this._simplified = this.checkSimplified();
    }

    protected Comparison(IntegerExpression left, IntegerExpression right) {
        this._expr = new Addition(left, right.multiply(-1));
    }

    public IntegerExpression queryExpression() {
        return this._expr;
    }

    @Override
    public boolean evaluate(Valuation val) {
        return this.evaluate(this._expr.evaluate(val));
    }

    protected boolean checkSimplified() {
        if (!this._expr.isSimplified()) {
            return false;
        }
        IntegerExpression integerExpression = this._expr;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, CMult.class, Multiplication.class, Addition.class}, (Object)integerExpression2, n)) {
            case 0 -> {
                IValue i = (IValue)integerExpression2;
                yield false;
            }
            case 1 -> {
                CMult c = (CMult)integerExpression2;
                yield false;
            }
            case 2 -> {
                Multiplication m = (Multiplication)integerExpression2;
                yield false;
            }
            case 3 -> {
                Addition a = (Addition)integerExpression2;
                IntegerExpression var8_7 = a.queryChild(a.numChildren());
                if (var8_7 instanceof CMult) {
                    CMult c = (CMult)var8_7;
                    if (!(c.queryConstant() <= 0 || a.numChildren() <= 2 && a.queryChild(1) instanceof IValue)) {
                        yield true;
                    }
                    yield false;
                }
                yield true;
            }
            default -> true;
        };
    }

    @Override
    public Constraint simplify() {
        IntegerExpression integerExpression;
        CMult c;
        Addition a;
        IntegerExpression integerExpression2;
        Multiplication m;
        CMult c2;
        if (this._simplified) {
            return this;
        }
        IntegerExpression e = this._expr;
        if (e instanceof CMult && (c2 = (CMult)e).queryConstant() != 0) {
            e = c2.queryChild();
        }
        if (e instanceof Multiplication) {
            m = (Multiplication)e;
            return this.simplifyMultiplication(m);
        }
        if ((e = e.simplify()) instanceof CMult) {
            c2 = (CMult)e;
            e = c2.queryChild();
        }
        if (e instanceof Multiplication) {
            m = (Multiplication)e;
            return this.simplifyMultiplication(m);
        }
        if (e instanceof IValue) {
            IValue v = (IValue)e;
            return this.evaluate(v.queryValue()) ? new Truth() : new Falsehood();
        }
        if (e instanceof Addition && (integerExpression2 = (a = (Addition)e).queryChild(a.numChildren())) instanceof CMult && (c = (CMult)integerExpression2).queryConstant() < 0) {
            e = e.negate();
        }
        if (e instanceof Addition && (integerExpression = (a = (Addition)e).queryChild(a.numChildren())) instanceof CMult) {
            c = (CMult)integerExpression;
            if (a.numChildren() == 2 && (integerExpression = a.queryChild(1)) instanceof IValue) {
                IValue i = (IValue)integerExpression;
                int k = i.queryValue();
                if (k % c.queryConstant() == 0) {
                    e = c.queryChild().add(k / c.queryConstant());
                } else {
                    if (this instanceof Is0) {
                        return new Falsehood();
                    }
                    return new Truth();
                }
            }
        }
        if (this instanceof Is0) {
            return new Is0(e);
        }
        return new Neq0(e);
    }

    private Constraint simplifyMultiplication(Multiplication m) {
        ArrayList<Constraint> parts = new ArrayList<Constraint>();
        if (this instanceof Is0) {
            for (int i = 1; i <= m.numChildren(); ++i) {
                parts.add(new Is0(m.queryChild(i)));
            }
            return new Disjunction(parts).simplify();
        }
        for (int i = 1; i <= m.numChildren(); ++i) {
            parts.add(new Neq0(m.queryChild(i)));
        }
        return new Conjunction(parts).simplify();
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(");
        builder.append(this.symbol());
        builder.append(" ");
        this._expr.addToSmtString(builder);
        builder.append(" 0)");
    }

    @Override
    public int compareTo(Constraint other) {
        Constraint constraint = other;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Falsehood.class, Truth.class, BVar.class, NBVar.class, Comparison.class, Junction.class, Iff.class, EqS.class, UneqS.class}, (Object)constraint2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Falsehood f = (Falsehood)constraint2;
                yield 1;
            }
            case 1 -> {
                Truth t = (Truth)constraint2;
                yield 1;
            }
            case 2 -> {
                BVar x = (BVar)constraint2;
                yield 1;
            }
            case 3 -> {
                NBVar x = (NBVar)constraint2;
                yield 1;
            }
            case 4 -> {
                Comparison comp = (Comparison)constraint2;
                int cmp = this._expr.compareTo(comp._expr);
                if (cmp != 0) {
                    yield cmp * 2;
                }
                Comparison v2 = this;
                Objects.requireNonNull(v2);
                Comparison var10_11 = v2;
                int var11_13 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Is0.class, Neq0.class, Geq0.class}, (Object)var10_11, var11_13)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Is0 i = (Is0)var10_11;
                        if (other instanceof Is0) {
                            yield 0;
                        }
                        yield -1;
                    }
                    case 1: {
                        Neq0 n = (Neq0)var10_11;
                        if (other instanceof Neq0) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 2: 
                }
                Geq0 g = (Geq0)var10_11;
                if (other instanceof Is0) {
                    yield 1;
                }
                if (other instanceof Geq0) {
                    yield 0;
                }
                yield -1;
            }
            case 5 -> {
                Junction j = (Junction)constraint2;
                yield -1;
            }
            case 6 -> {
                Iff i = (Iff)constraint2;
                yield -1;
            }
            case 7 -> {
                EqS e = (EqS)constraint2;
                yield -1;
            }
            case 8 -> {
                UneqS u = (UneqS)constraint2;
                yield -1;
            }
        };
    }
}

