/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.Disjunction;
import charlie.smt.EqS;
import charlie.smt.Falsehood;
import charlie.smt.Geq0;
import charlie.smt.Is0;
import charlie.smt.Junction;
import charlie.smt.NBVar;
import charlie.smt.Neq0;
import charlie.smt.Truth;
import charlie.smt.UneqS;
import charlie.smt.Valuation;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public final class Conjunction
extends Junction {
    Conjunction(Constraint a, Constraint b) {
        super(a, b);
    }

    Conjunction(List<Constraint> args) {
        super(args);
    }

    @Override
    protected String symbol() {
        return "and";
    }

    @Override
    public boolean evaluate(Valuation val) {
        for (int i = 0; i < this._children.size(); ++i) {
            if (((Constraint)this._children.get(i)).evaluate(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Constraint negate() {
        ArrayList<Constraint> arr = new ArrayList<Constraint>();
        for (Constraint c : this._children) {
            arr.add(c.negate());
        }
        if (this._simplified) {
            return new Disjunction(arr).simplify();
        }
        return new Disjunction(arr);
    }

    @Override
    public Constraint simplify() {
        if (this._simplified) {
            return this;
        }
        TreeSet<Constraint> set = new TreeSet<Constraint>();
        for (Constraint c : this._children) {
            Constraint child = c.simplify();
            if (child instanceof Falsehood) {
                return child;
            }
            if (child instanceof Truth) continue;
            if (child instanceof Conjunction) {
                Conjunction conj = (Conjunction)child;
                for (Constraint cc : conj._children) {
                    set.add(cc);
                }
                continue;
            }
            set.add(child);
        }
        ArrayList<Constraint> a = new ArrayList<Constraint>(set.size());
        boolean reorder = false;
        for (Constraint c : set) {
            Neq0 n;
            Is0 i;
            a.add(c);
            if (a.size() == 1) continue;
            Constraint prev = a.get(a.size() - 2);
            if (prev instanceof BVar) {
                BVar x = (BVar)prev;
                if (c instanceof NBVar) {
                    NBVar y = (NBVar)c;
                    if (x.queryIndex() == y.queryIndex()) {
                        return new Falsehood();
                    }
                }
            }
            if (prev instanceof EqS && c instanceof UneqS && prev.compareTo(c) == -1) {
                return new Falsehood();
            }
            if (prev instanceof Is0) {
                i = (Is0)prev;
                if (c instanceof Neq0) {
                    n = (Neq0)c;
                    if (i.queryExpression().equals(n.queryExpression())) {
                        return new Falsehood();
                    }
                }
            }
            if (prev instanceof Is0) {
                i = (Is0)prev;
                if (c instanceof Geq0) {
                    Geq0 g = (Geq0)c;
                    if (i.queryExpression().equals(g.queryExpression())) {
                        a.remove(a.size() - 1);
                    }
                }
            }
            if (!(prev instanceof Geq0)) continue;
            Geq0 g = (Geq0)prev;
            if (!(c instanceof Neq0)) continue;
            n = (Neq0)c;
            if (!g.queryExpression().equals(n.queryExpression())) continue;
            a.remove(a.size() - 1);
            a.remove(a.size() - 1);
            a.add(new Geq0(g.queryExpression().add(-1)));
            reorder = true;
        }
        if (a.size() == 0) {
            return new Truth();
        }
        if (a.size() == 1) {
            return (Constraint)a.get(0);
        }
        if (reorder) {
            return new Conjunction(a).simplify();
        }
        return new Conjunction(a);
    }

    public int hashCode() {
        return 17 * this._children.hashCode() + 2;
    }
}

