/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.BVar;
import charlie.smt.Comparison;
import charlie.smt.Conjunction;
import charlie.smt.Constraint;
import charlie.smt.Disjunction;
import charlie.smt.EqS;
import charlie.smt.Falsehood;
import charlie.smt.Geq0;
import charlie.smt.IExpPrinter;
import charlie.smt.Iff;
import charlie.smt.IntegerExpression;
import charlie.smt.Is0;
import charlie.smt.NBVar;
import charlie.smt.Neq0;
import charlie.smt.SExpPrinter;
import charlie.smt.Truth;
import charlie.smt.UneqS;
import charlie.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class ConstraintPrinter {
    protected IExpPrinter _expPrinter;
    protected SExpPrinter _stringPrinter;

    public ConstraintPrinter() {
        this._expPrinter = new IExpPrinter();
        this._stringPrinter = new SExpPrinter();
    }

    public ConstraintPrinter(IExpPrinter e, SExpPrinter s) {
        this._expPrinter = e;
        this._stringPrinter = s;
    }

    public final String print(Constraint e) {
        StringBuilder builder = new StringBuilder();
        this.print(e, builder);
        return builder.toString();
    }

    public void print(Constraint c, StringBuilder builder) {
        Constraint constraint = c;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BVar.class, NBVar.class, Truth.class, Falsehood.class, Geq0.class, Is0.class, Neq0.class, Conjunction.class, Disjunction.class, Iff.class, EqS.class, UneqS.class}, (Object)constraint2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                BVar x = (BVar)constraint2;
                this.printVar(x, builder);
                break;
            }
            case 1: {
                NBVar x = (NBVar)constraint2;
                this.printNegatedVar(x, builder);
                break;
            }
            case 2: {
                Truth t = (Truth)constraint2;
                this.printTruth(builder);
                break;
            }
            case 3: {
                Falsehood f = (Falsehood)constraint2;
                this.printFalsehood(builder);
                break;
            }
            case 4: {
                Geq0 g = (Geq0)constraint2;
                this.printGeq(g, builder);
                break;
            }
            case 5: {
                Is0 i = (Is0)constraint2;
                this.printEquals(i, builder);
                break;
            }
            case 6: {
                Neq0 n2 = (Neq0)constraint2;
                this.printDistinct(n2, builder);
                break;
            }
            case 7: {
                Conjunction j = (Conjunction)constraint2;
                this.printConjunction(j, builder);
                break;
            }
            case 8: {
                Disjunction j = (Disjunction)constraint2;
                this.printDisjunction(j, builder);
                break;
            }
            case 9: {
                Iff i = (Iff)constraint2;
                this.printIff(i, builder);
                break;
            }
            case 10: {
                EqS e = (EqS)constraint2;
                this.printEqS(e, builder);
                break;
            }
            case 11: {
                UneqS u = (UneqS)constraint2;
                this.printUneqS(u, builder);
            }
        }
    }

    protected void printVar(BVar x, StringBuilder builder) {
        builder.append(x.queryName());
    }

    protected void printNegatedVar(NBVar x, StringBuilder builder) {
        builder.append("!");
        builder.append(x.queryName());
    }

    protected void printTruth(StringBuilder builder) {
        builder.append("true");
    }

    protected void printFalsehood(StringBuilder builder) {
        builder.append("false");
    }

    protected void printComparison(Comparison comp, String symbol, StringBuilder builder) {
        IntegerExpression main = comp.queryExpression();
        symbol = " " + (String)symbol + " ";
        if (main instanceof Addition) {
            Addition a = (Addition)main;
            Pair<IntegerExpression, IntegerExpression> pair = a.split();
            this._expPrinter.print(pair.fst(), builder);
            builder.append((String)symbol);
            this._expPrinter.print(pair.snd(), builder);
        } else {
            this._expPrinter.print(main, builder);
            builder.append((String)symbol);
            builder.append("0");
        }
    }

    protected void printGeq(Geq0 constr, StringBuilder builder) {
        this.printComparison(constr, ">=", builder);
    }

    protected void printEquals(Is0 constr, StringBuilder builder) {
        this.printComparison(constr, "=", builder);
    }

    protected void printDistinct(Neq0 constr, StringBuilder builder) {
        this.printComparison(constr, "#", builder);
    }

    protected final void printBracketed(Constraint constr, StringBuilder builder) {
        Constraint constraint = constr;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BVar.class, NBVar.class, Truth.class, Falsehood.class}, (Object)constraint2, n)) {
            case 0: {
                BVar x = (BVar)constraint2;
                this.printVar(x, builder);
                break;
            }
            case 1: {
                NBVar x = (NBVar)constraint2;
                this.printNegatedVar(x, builder);
                break;
            }
            case 2: {
                Truth t = (Truth)constraint2;
                this.printTruth(builder);
                break;
            }
            case 3: {
                Falsehood f = (Falsehood)constraint2;
                this.printFalsehood(builder);
                break;
            }
            default: {
                builder.append("(");
                this.print(constr, builder);
                builder.append(")");
            }
        }
    }

    protected void printConjunction(Conjunction constr, StringBuilder builder) {
        if (constr.numChildren() == 0) {
            builder.append("[true]");
        } else {
            this.printBracketed(constr.queryChild(1), builder);
            for (int i = 2; i <= constr.numChildren(); ++i) {
                builder.append(" and ");
                this.printBracketed(constr.queryChild(i), builder);
            }
        }
    }

    protected void printDisjunction(Disjunction constr, StringBuilder builder) {
        if (constr.numChildren() == 0) {
            builder.append("[false]");
        } else {
            this.printBracketed(constr.queryChild(1), builder);
            for (int i = 2; i <= constr.numChildren(); ++i) {
                builder.append(" or ");
                this.printBracketed(constr.queryChild(i), builder);
            }
        }
    }

    protected void printIff(Iff i, StringBuilder builder) {
        this.printBracketed(i.queryLeft(), builder);
        builder.append(" == ");
        this.printBracketed(i.queryRight(), builder);
    }

    protected void printEqS(EqS e, StringBuilder builder) {
        this._stringPrinter.print(e.queryLeft(), builder);
        builder.append(" = ");
        this._stringPrinter.print(e.queryRight(), builder);
    }

    protected void printUneqS(UneqS u, StringBuilder builder) {
        this._stringPrinter.print(u.queryLeft(), builder);
        builder.append(" # ");
        this._stringPrinter.print(u.queryRight(), builder);
    }
}

