/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.BVar;
import charlie.smt.Conjunction;
import charlie.smt.Constraint;
import charlie.smt.EqS;
import charlie.smt.Falsehood;
import charlie.smt.Geq0;
import charlie.smt.Is0;
import charlie.smt.Junction;
import charlie.smt.NBVar;
import charlie.smt.Neq0;
import charlie.smt.Truth;
import charlie.smt.UneqS;
import charlie.smt.Valuation;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public final class Disjunction
extends Junction {
    Disjunction(Constraint a, Constraint b) {
        super(a, b);
    }

    Disjunction(List<Constraint> args) {
        super(args);
    }

    @Override
    protected String symbol() {
        return "or";
    }

    @Override
    public boolean evaluate(Valuation val) {
        for (int i = 0; i < this._children.size(); ++i) {
            if (!((Constraint)this._children.get(i)).evaluate(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Constraint negate() {
        ArrayList<Constraint> arr = new ArrayList<Constraint>();
        for (Constraint c : this._children) {
            arr.add(c.negate());
        }
        if (this._simplified) {
            return new Conjunction(arr).simplify();
        }
        return new Conjunction(arr);
    }

    @Override
    public Constraint simplify() {
        if (this._simplified) {
            return this;
        }
        TreeSet<Constraint> set = new TreeSet<Constraint>();
        for (Constraint c : this._children) {
            Constraint child = c.simplify();
            if (child instanceof Falsehood) continue;
            if (child instanceof Truth) {
                return child;
            }
            if (child instanceof Disjunction) {
                Disjunction disj = (Disjunction)child;
                for (Constraint cc : disj._children) {
                    set.add(cc);
                }
                continue;
            }
            set.add(child);
        }
        ArrayList<Constraint> a = new ArrayList<Constraint>(set.size());
        for (Constraint c : set) {
            if (a.size() == 0) {
                a.add(c);
                continue;
            }
            Constraint prev = a.get(a.size() - 1);
            if (prev instanceof BVar) {
                BVar x = (BVar)prev;
                if (c instanceof NBVar) {
                    NBVar y = (NBVar)c;
                    if (x.queryIndex() == y.queryIndex()) {
                        return new Truth();
                    }
                }
            }
            if (prev instanceof EqS && c instanceof UneqS && prev.compareTo(c) == -1) {
                return new Truth();
            }
            if (c instanceof Neq0) {
                Geq0 g;
                Is0 i;
                Neq0 n = (Neq0)c;
                if (prev instanceof Is0 && (i = (Is0)prev).queryExpression().equals(n.queryExpression()) || prev instanceof Geq0 && (g = (Geq0)prev).queryExpression().equals(n.queryExpression())) {
                    return new Truth();
                }
            }
            if (prev instanceof Is0) {
                Is0 i = (Is0)prev;
                if (c instanceof Geq0) {
                    Geq0 g = (Geq0)c;
                    if (i.queryExpression().equals(g.queryExpression())) {
                        a.set(a.size() - 1, c);
                        continue;
                    }
                }
            }
            a.add(c);
        }
        if (a.size() == 0) {
            return new Falsehood();
        }
        if (a.size() == 1) {
            return (Constraint)a.get(0);
        }
        return new Disjunction(a);
    }

    public int hashCode() {
        return 17 * this._children.hashCode() + 3;
    }
}

