/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.CMult;
import charlie.smt.IValue;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.Modulo;
import charlie.smt.Multiplication;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class Division
extends IntegerExpression {
    private IntegerExpression _numerator;
    private IntegerExpression _denominator;

    Division(IntegerExpression n, IntegerExpression d) {
        this._numerator = n;
        this._denominator = d;
        this.checkSimplified();
    }

    public IntegerExpression queryNumerator() {
        return this._numerator;
    }

    public IntegerExpression queryDenominator() {
        return this._denominator;
    }

    @Override
    public int evaluate(Valuation val) {
        return Division.evaluateFor(this._numerator.evaluate(val), this._denominator.evaluate(val));
    }

    private static int evaluateFor(int n, int d) {
        int abs_d;
        if (d == 0) {
            return 0;
        }
        int sign = n >= 0 && d >= 0 || n < 0 && d < 0 ? 1 : -1;
        int abs_n = n >= 0 ? n : -n;
        int n2 = abs_d = d >= 0 ? d : -d;
        if (n >= 0) {
            return sign * (abs_n / abs_d);
        }
        if (abs_n % abs_d == 0) {
            return sign * (abs_n / abs_d);
        }
        return sign * (abs_n / abs_d + 1);
    }

    private void checkSimplified() {
        CMult cm;
        IValue k;
        if (this._numerator instanceof IValue && this._denominator instanceof IValue) {
            return;
        }
        if (!this._numerator.isSimplified() || !this._denominator.isSimplified()) {
            return;
        }
        IntegerExpression integerExpression = this._denominator;
        this._simplified = integerExpression instanceof IValue ? (k = (IValue)integerExpression).queryValue() != 1 && k.queryValue() >= 0 : ((integerExpression = this._denominator) instanceof CMult ? (cm = (CMult)integerExpression).queryConstant() >= 2 : true);
    }

    @Override
    public IntegerExpression simplify() {
        if (this._simplified) {
            return this;
        }
        IntegerExpression n = this._numerator.simplify();
        IntegerExpression d = this._denominator.simplify();
        IntegerExpression integerExpression = this._denominator;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, CMult.class}, (Object)integerExpression2, n2)) {
            case 0: {
                IValue k = (IValue)integerExpression2;
                if (n instanceof IValue) {
                    IValue i = (IValue)n;
                    return new IValue(Division.evaluateFor(i.queryValue(), k.queryValue()));
                }
                if (k.queryValue() == 1) {
                    return this._numerator;
                }
                if (k.queryValue() == -1) {
                    return this._numerator.multiply(-1);
                }
                if (k.queryValue() < 0) {
                    CMult ret = new CMult(-1, new Division(n, k.multiply(-1)));
                    return ((IntegerExpression)ret).simplify();
                }
                return new Division(n, d);
            }
            case 1: {
                CMult cm = (CMult)integerExpression2;
                if (cm.queryConstant() >= 0) break;
                CMult ret = new CMult(-1, new Division(n, cm.multiply(-1)));
                return ((IntegerExpression)ret).simplify();
            }
        }
        return new Division(n, d);
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(div ");
        this._numerator.addToSmtString(builder);
        builder.append(" ");
        this._denominator.addToSmtString(builder);
        builder.append(")");
    }

    @Override
    public int compareTo(IntegerExpression other) {
        IntegerExpression integerExpression = other;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, IVar.class, CMult.class, Addition.class, Multiplication.class, Division.class, Modulo.class}, (Object)integerExpression2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IValue v = (IValue)integerExpression2;
                yield 1;
            }
            case 1 -> {
                IVar x = (IVar)integerExpression2;
                yield 1;
            }
            case 2 -> {
                CMult cm = (CMult)integerExpression2;
                if (this.compareTo(cm.queryChild()) <= 0) {
                    yield -1;
                }
                yield 1;
            }
            case 3 -> {
                Addition a = (Addition)integerExpression2;
                yield 1;
            }
            case 4 -> {
                Multiplication m = (Multiplication)integerExpression2;
                yield 1;
            }
            case 5 -> {
                Division d = (Division)integerExpression2;
                int c = this._denominator.compareTo(d._denominator);
                if (c != 0) {
                    yield c;
                }
                yield this._numerator.compareTo(d._numerator);
            }
            case 6 -> {
                Modulo m = (Modulo)integerExpression2;
                yield -1;
            }
        };
    }

    public int hashCode() {
        return 7 * (this._numerator.hashCode() * 31 + this._denominator.hashCode()) + 5;
    }
}

