/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Constraint;
import charlie.smt.Falsehood;
import charlie.smt.SValue;
import charlie.smt.SVar;
import charlie.smt.StringExpression;
import charlie.smt.Truth;
import charlie.smt.UneqS;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class EqS
extends Constraint {
    private StringExpression _left;
    private StringExpression _right;

    EqS(StringExpression left, StringExpression right) {
        if (left.compareTo(right) >= 0) {
            this._left = left;
            this._right = right;
        } else {
            this._left = right;
            this._right = left;
        }
        this._simplified = this._left.equals(this._right) ? false : this._left instanceof SVar || this._right instanceof SVar;
    }

    public StringExpression queryLeft() {
        return this._left;
    }

    public StringExpression queryRight() {
        return this._right;
    }

    @Override
    public boolean evaluate(Valuation val) {
        return this._left.evaluate(val).equals(this._right.evaluate(val));
    }

    @Override
    public Constraint simplify() {
        if (this._left.equals(this._right)) {
            return new Truth();
        }
        StringExpression stringExpression = this._left;
        if (stringExpression instanceof SValue) {
            SValue l = (SValue)stringExpression;
            stringExpression = this._right;
            if (stringExpression instanceof SValue) {
                SValue r = (SValue)stringExpression;
                return new Falsehood();
            }
        }
        return this;
    }

    @Override
    public UneqS negate() {
        return new UneqS(this._left, this._right);
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(= ");
        this._left.addToSmtString(builder);
        builder.append(" ");
        this._right.addToSmtString(builder);
        builder.append(")");
    }

    @Override
    public int compareTo(Constraint other) {
        Constraint constraint = other;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UneqS.class, EqS.class}, (Object)constraint2, n)) {
            case 0 -> {
                UneqS uns = (UneqS)constraint2;
                int c = this._left.compareTo(uns.queryLeft());
                if (c == 0) {
                    c = this._right.compareTo(uns.queryRight());
                }
                if (c == 0) {
                    yield -1;
                }
                yield 2 * c;
            }
            case 1 -> {
                EqS eqs = (EqS)constraint2;
                int c = this._left.compareTo(eqs._left);
                if (c == 0) {
                    c = this._right.compareTo(eqs._right);
                }
                yield c * 2;
            }
            default -> 1;
        };
    }

    public int hashCode() {
        return 17 * (this._left.hashCode() + 31 * this._right.hashCode()) + 8;
    }
}

