/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.CMult;
import charlie.smt.Comparison;
import charlie.smt.Constraint;
import charlie.smt.Falsehood;
import charlie.smt.IValue;
import charlie.smt.IntegerExpression;
import charlie.smt.Truth;

public final class Geq0
extends Comparison {
    Geq0(IntegerExpression expr) {
        super(expr);
    }

    Geq0(IntegerExpression left, IntegerExpression right) {
        super(left, right);
    }

    @Override
    protected boolean evaluate(int num) {
        return num >= 0;
    }

    @Override
    protected String symbol() {
        return ">=";
    }

    public int hashCode() {
        return 17 * this._expr.hashCode() + 4;
    }

    @Override
    public Constraint negate() {
        Geq0 ret = new Geq0(this._expr.negate().add(-1));
        if (this._simplified) {
            return ((Constraint)ret).simplify();
        }
        return ret;
    }

    @Override
    protected boolean checkSimplified() {
        Addition a;
        if (!this._expr.isSimplified() || this._expr instanceof IValue) {
            return false;
        }
        IntegerExpression integerExpression = this._expr;
        if (integerExpression instanceof CMult) {
            CMult c = (CMult)integerExpression;
            return c.queryConstant() == -1;
        }
        IntegerExpression integerExpression2 = this._expr;
        if (integerExpression2 instanceof Addition && (integerExpression2 = (a = (Addition)integerExpression2).queryChild(a.numChildren())) instanceof CMult) {
            CMult c = (CMult)integerExpression2;
            if (a.numChildren() == 2 && a.queryChild(1) instanceof IValue) {
                return c.queryConstant() == -1;
            }
        }
        return true;
    }

    @Override
    public Constraint simplify() {
        IntegerExpression integerExpression;
        Addition ad;
        if (this._simplified) {
            return this;
        }
        IntegerExpression e = this.removeCMult(this.removeCMult(this._expr).simplify());
        if (e instanceof IValue) {
            IValue v = (IValue)e;
            return v.queryValue() >= 0 ? new Truth() : new Falsehood();
        }
        if (e instanceof Addition && (ad = (Addition)e).numChildren() == 2 && (integerExpression = ad.queryChild(1)) instanceof IValue) {
            CMult c;
            IValue k = (IValue)integerExpression;
            integerExpression = ad.queryChild(2);
            if (integerExpression instanceof CMult && (c = (CMult)integerExpression).queryConstant() != -1) {
                int a = c.queryConstant();
                int b = k.queryValue();
                if (a > 1) {
                    int v;
                    int n = v = b < 0 ? -((-b + a - 1) / a) : b / a;
                    e = v == 0 ? c.queryChild() : new Addition(new IValue(v), c.queryChild());
                } else {
                    int v = b > 0 ? b / -a : -((-b - a - 1) / -a);
                    e = v == 0 ? new CMult(-1, c.queryChild()) : new Addition(new IValue(v), new CMult(-1, c.queryChild()));
                }
            }
        }
        return new Geq0(e);
    }

    protected IntegerExpression removeCMult(IntegerExpression e) {
        if (e instanceof CMult) {
            CMult c = (CMult)e;
            int k = c.queryConstant();
            if (k > 0) {
                return c.queryChild();
            }
            if (k < -1) {
                return new CMult(-1, c.queryChild());
            }
        }
        return e;
    }
}

