/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.CMult;
import charlie.smt.Division;
import charlie.smt.IValue;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.Modulo;
import charlie.smt.Multiplication;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class IExpPrinter {
    public final String print(IntegerExpression e) {
        StringBuilder builder = new StringBuilder();
        this.print(e, builder);
        return builder.toString();
    }

    public void print(IntegerExpression e, StringBuilder builder) {
        IntegerExpression integerExpression = e;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IVar.class, IValue.class, Division.class, Modulo.class, Multiplication.class, CMult.class, Addition.class}, (Object)integerExpression2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                IVar x = (IVar)integerExpression2;
                this.printVar(x, builder);
                break;
            }
            case 1: {
                IValue k = (IValue)integerExpression2;
                this.printValue(k, builder);
                break;
            }
            case 2: {
                Division d = (Division)integerExpression2;
                this.printDivision(d, builder);
                break;
            }
            case 3: {
                Modulo m = (Modulo)integerExpression2;
                this.printModulo(m, builder);
                break;
            }
            case 4: {
                Multiplication m = (Multiplication)integerExpression2;
                this.printMultiplication(m, builder);
                break;
            }
            case 5: {
                CMult c = (CMult)integerExpression2;
                this.printCMult(c, builder);
                break;
            }
            case 6: {
                Addition a = (Addition)integerExpression2;
                this.printAddition(a, builder);
            }
        }
    }

    protected final void printBracketed(IntegerExpression e, StringBuilder builder) {
        IntegerExpression integerExpression = e;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IVar.class, IValue.class}, (Object)integerExpression2, n)) {
            case 0: {
                IVar x = (IVar)integerExpression2;
                this.printVar(x, builder);
                break;
            }
            case 1: {
                IValue k = (IValue)integerExpression2;
                this.printValue(k, builder);
                break;
            }
            default: {
                builder.append("(");
                this.print(e, builder);
                builder.append(")");
            }
        }
    }

    protected void printVar(IVar x, StringBuilder builder) {
        builder.append(x.queryName());
    }

    protected void printValue(IValue k, StringBuilder builder) {
        builder.append("" + k.queryValue());
    }

    protected void printDivision(Division d, StringBuilder builder) {
        this.printBracketed(d.queryNumerator(), builder);
        builder.append(" / ");
        this.printBracketed(d.queryDenominator(), builder);
    }

    protected void printModulo(Modulo m, StringBuilder builder) {
        this.printBracketed(m.queryNumerator(), builder);
        builder.append(" % ");
        this.printBracketed(m.queryDenominator(), builder);
    }

    protected void printMultiplication(Multiplication m, StringBuilder builder) {
        if (m.numChildren() == 0) {
            builder.append("(1)");
            return;
        }
        this.printBracketed(m.queryChild(1), builder);
        for (int i = 2; i <= m.numChildren(); ++i) {
            builder.append(" * ");
            this.printBracketed(m.queryChild(i), builder);
        }
    }

    protected void printCMult(CMult c, StringBuilder builder) {
        if (c.queryConstant() == -1) {
            builder.append("-");
            IntegerExpression integerExpression = c.queryChild();
            if (integerExpression instanceof IVar) {
                IVar x = (IVar)integerExpression;
                this.printVar(x, builder);
            } else {
                builder.append("(");
                this.print(c.queryChild(), builder);
                builder.append(")");
            }
        } else {
            builder.append("" + c.queryConstant());
            builder.append(" * ");
            IntegerExpression integerExpression = c.queryChild();
            if (integerExpression instanceof Multiplication) {
                Multiplication m = (Multiplication)integerExpression;
                this.printMultiplication(m, builder);
            } else {
                this.printBracketed(c.queryChild(), builder);
            }
        }
    }

    protected void printAddition(Addition a, StringBuilder builder) {
        if (a.numChildren() == 0) {
            builder.append("(0)");
            return;
        }
        this.print(a.queryChild(1), builder);
        for (int i = 2; i <= a.numChildren(); ++i) {
            builder.append(" + ");
            this.print(a.queryChild(i), builder);
        }
    }
}

