/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.CMult;
import charlie.smt.Division;
import charlie.smt.IValue;
import charlie.smt.IntegerExpression;
import charlie.smt.Modulo;
import charlie.smt.Multiplication;
import charlie.smt.SmtEvaluationException;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class IVar
extends IntegerExpression {
    private int _index;
    private String _name;

    IVar(int i) {
        this._index = i;
        this._name = "i" + this._index;
        this._simplified = true;
    }

    IVar(int i, String name) {
        this._index = i;
        this._name = "[" + name + "]";
        this._simplified = true;
    }

    public int queryIndex() {
        return this._index;
    }

    public String queryName() {
        return this._name;
    }

    @Override
    public int evaluate(Valuation val) {
        if (val == null) {
            throw new SmtEvaluationException(this);
        }
        return val.queryIntAssignment(this._index);
    }

    @Override
    public IntegerExpression simplify() {
        return this;
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("i" + this._index);
    }

    @Override
    public int compareTo(IntegerExpression other) {
        IntegerExpression integerExpression = other;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, IVar.class, CMult.class, Addition.class, Multiplication.class, Division.class, Modulo.class}, (Object)integerExpression2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IValue v = (IValue)integerExpression2;
                yield 1;
            }
            case 1 -> {
                IVar x = (IVar)integerExpression2;
                yield this._index - x.queryIndex();
            }
            case 2 -> {
                CMult cm = (CMult)integerExpression2;
                if (this.compareTo(cm.queryChild()) <= 0) {
                    yield -1;
                }
                yield 1;
            }
            case 3 -> {
                Addition a = (Addition)integerExpression2;
                yield -1;
            }
            case 4 -> {
                Multiplication m = (Multiplication)integerExpression2;
                yield -1;
            }
            case 5 -> {
                Division d = (Division)integerExpression2;
                yield -1;
            }
            case 6 -> {
                Modulo m = (Modulo)integerExpression2;
                yield -1;
            }
        };
    }

    public int hashCode() {
        return 7 * this._index + 1;
    }
}

