/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.BVar;
import charlie.smt.Comparison;
import charlie.smt.Constraint;
import charlie.smt.EqS;
import charlie.smt.Falsehood;
import charlie.smt.Geq0;
import charlie.smt.Is0;
import charlie.smt.NBVar;
import charlie.smt.Neq0;
import charlie.smt.Truth;
import charlie.smt.UneqS;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class Iff
extends Constraint {
    private Constraint _left;
    private Constraint _right;

    Iff(Constraint a, Constraint b) {
        this._left = a;
        this._right = b;
        this._simplified = this.checkSimplified();
    }

    public Constraint queryLeft() {
        return this._left;
    }

    public Constraint queryRight() {
        return this._right;
    }

    @Override
    public boolean evaluate(Valuation val) {
        return this._left.evaluate(val) == this._right.evaluate(val);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkSimplified() {
        if (!this._left.isSimplified()) return false;
        if (!this._right.isSimplified()) {
            return false;
        }
        int c = this._left.compareTo(this._right);
        if (c >= 0) {
            return false;
        }
        Constraint constraint = this._left;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Falsehood.class, Truth.class, BVar.class, Comparison.class}, (Object)constraint2, n)) {
            case 0: {
                Falsehood f = (Falsehood)constraint2;
                return false;
            }
            case 1: {
                Truth t = (Truth)constraint2;
                return false;
            }
            case 2: {
                BVar x = (BVar)constraint2;
                Constraint constraint3 = this._right;
                if (!(constraint3 instanceof NBVar)) return true;
                NBVar y = (NBVar)constraint3;
                if (x.queryIndex() == y.queryIndex()) return false;
                return true;
            }
            case 3: {
                Comparison o = (Comparison)constraint2;
                if (c > -2) return false;
                return true;
            }
            default: {
                return true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Constraint simplify() {
        Constraint r;
        if (this._simplified) {
            return this;
        }
        Constraint l = this._left.simplify();
        int c = l.compareTo(r = this._right.simplify());
        if (c == 0) {
            return new Truth();
        }
        if (c > 0) {
            Constraint tmp = l;
            l = r;
            r = tmp;
            c = -c;
        }
        if (l instanceof Falsehood) {
            return r.negate();
        }
        if (l instanceof Truth) {
            return r;
        }
        if (l instanceof BVar) {
            BVar x = (BVar)l;
            if (!(r instanceof NBVar)) return new Iff(l, r);
            NBVar y = (NBVar)r;
            if (x.queryIndex() != y.queryIndex()) return new Iff(l, r);
            return new Falsehood();
        }
        if (l instanceof Is0) {
            Is0 a = (Is0)l;
            if (c == -1) {
                if (r instanceof Neq0) {
                    return new Falsehood();
                }
                if (!(r instanceof Geq0)) return new Iff(l, r);
                return new Geq0(a.queryExpression().negate()).simplify();
            }
        }
        if (!(l instanceof Geq0)) return new Iff(l, r);
        Geq0 a = (Geq0)l;
        if (c != -1 || !(r instanceof Neq0)) return new Iff(l, r);
        return new Geq0(a.queryExpression().add(-1)).simplify();
    }

    private int queryConstraintKind(Constraint c) {
        Constraint constraint = c;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Truth.class, Falsehood.class, BVar.class, NBVar.class, EqS.class, UneqS.class, Iff.class, Comparison.class}, (Object)constraint2, n)) {
            case 0 -> {
                Truth x = (Truth)constraint2;
                yield 1;
            }
            case 1 -> {
                Falsehood x = (Falsehood)constraint2;
                yield 1;
            }
            case 2 -> {
                BVar x = (BVar)constraint2;
                yield 1;
            }
            case 3 -> {
                NBVar x = (NBVar)constraint2;
                yield 1;
            }
            case 4 -> {
                EqS x = (EqS)constraint2;
                yield 2;
            }
            case 5 -> {
                UneqS x = (UneqS)constraint2;
                yield 2;
            }
            case 6 -> {
                Iff x = (Iff)constraint2;
                yield 3;
            }
            case 7 -> {
                Comparison x = (Comparison)constraint2;
                yield 4;
            }
            default -> 5;
        };
    }

    @Override
    public Constraint negate() {
        Iff ret = this.queryConstraintKind(this._right) < this.queryConstraintKind(this._left) ? new Iff(this._left, this._right.negate()) : new Iff(this._left.negate(), this._right);
        if (this._simplified) {
            return ret.simplify();
        }
        return ret;
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(= ");
        this._left.addToSmtString(builder);
        builder.append(" ");
        this._right.addToSmtString(builder);
        builder.append(")");
    }

    @Override
    public int compareTo(Constraint other) {
        Constraint constraint = other;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EqS.class, UneqS.class, Iff.class}, (Object)constraint2, n)) {
            case 0 -> {
                EqS e = (EqS)constraint2;
                yield -1;
            }
            case 1 -> {
                UneqS u = (UneqS)constraint2;
                yield -1;
            }
            case 2 -> {
                Iff iff = (Iff)constraint2;
                int c = this._left.compareTo(iff._left);
                if (c == 0) {
                    c = this._right.compareTo(iff._right);
                }
                yield c;
            }
            default -> 1;
        };
    }

    public int hashCode() {
        return 17 * (this._left.hashCode() * 31 + this._right.hashCode()) + 7;
    }
}

