/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.CMult;
import charlie.smt.Division;
import charlie.smt.IExpPrinter;
import charlie.smt.IValue;
import charlie.smt.IVar;
import charlie.smt.Modulo;
import charlie.smt.Multiplication;
import charlie.smt.Valuation;

public abstract sealed class IntegerExpression
implements Comparable<IntegerExpression>
permits IVar, IValue, Division, Modulo, CMult, Multiplication, Addition {
    protected boolean _simplified = false;

    protected IntegerExpression() {
    }

    public abstract int evaluate(Valuation var1);

    public abstract void addToSmtString(StringBuilder var1);

    @Override
    public abstract int compareTo(IntegerExpression var1);

    public abstract IntegerExpression simplify();

    public final boolean isSimplified() {
        return this._simplified;
    }

    public IntegerExpression add(int constant) {
        if (constant == 0) {
            return this;
        }
        return new Addition(new IValue(constant), this);
    }

    public IntegerExpression multiply(int constant) {
        if (constant == 0) {
            return new IValue(0);
        }
        if (constant == 1) {
            return this;
        }
        return new CMult(constant, this);
    }

    public final int evaluate() {
        return this.evaluate(null);
    }

    public final IntegerExpression negate() {
        return this.multiply(-1);
    }

    public final String toString() {
        IExpPrinter printer = new IExpPrinter();
        return printer.print(this);
    }

    public final String toSmtString() {
        StringBuilder builder = new StringBuilder();
        this.addToSmtString(builder);
        return builder.toString();
    }

    public final boolean equals(Object other) {
        return other instanceof IntegerExpression && this.compareTo((IntegerExpression)other) == 0;
    }
}

