/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.BVar;
import charlie.smt.Comparison;
import charlie.smt.Conjunction;
import charlie.smt.Constraint;
import charlie.smt.Disjunction;
import charlie.smt.EqS;
import charlie.smt.Falsehood;
import charlie.smt.Iff;
import charlie.smt.NBVar;
import charlie.smt.Truth;
import charlie.smt.UneqS;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract sealed class Junction
extends Constraint
permits Conjunction, Disjunction {
    protected ArrayList<Constraint> _children = new ArrayList();

    protected abstract String symbol();

    Junction(Constraint a, Constraint b) {
        this.addChild(a);
        this.addChild(b);
        this._simplified = this.checkSimplified();
    }

    Junction(List<Constraint> args) {
        for (Constraint c : args) {
            this.addChild(c);
        }
    }

    private void addChild(Constraint child) {
        Junction j;
        if (child instanceof Junction && (j = (Junction)child).symbol().equals(this.symbol())) {
            for (int i = 1; i <= j.numChildren(); ++i) {
                this._children.add(j.queryChild(i));
            }
        } else {
            this._children.add(child);
        }
    }

    public int numChildren() {
        return this._children.size();
    }

    public Constraint queryChild(int index) {
        if (index <= 0 || index > this._children.size()) {
            throw new IndexOutOfBoundsException("Junction::queryChild(" + index + ") called on a junction with " + this._children.size() + " arguments! (" + this.toString() + ")");
        }
        return this._children.get(index - 1);
    }

    public boolean checkSimplified() {
        if (this._children.size() < 2) {
            return false;
        }
        if (this._children.get(0) instanceof Truth || this._children.get(0) instanceof Falsehood) {
            return false;
        }
        if (!this._children.get(0).isSimplified()) {
            return false;
        }
        for (int i = 1; i < this._children.size(); ++i) {
            NBVar n;
            Constraint c = this._children.get(i);
            int k = this._children.get(i - 1).compareTo(c);
            if (!c.isSimplified()) {
                return false;
            }
            if (k >= 0) {
                return false;
            }
            if (k == -1 && c instanceof Comparison) {
                return false;
            }
            if (k != -1 || !(c instanceof NBVar) || !(n = (NBVar)c).negate().equals(this._children.get(i - 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Constraint simplify() {
        return this;
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(");
        builder.append(this.symbol());
        for (int i = 0; i < this._children.size(); ++i) {
            builder.append(" ");
            this._children.get(i).addToSmtString(builder);
        }
        builder.append(")");
    }

    @Override
    public int compareTo(Constraint other) {
        Constraint constraint = other;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Falsehood.class, Truth.class, BVar.class, NBVar.class, Comparison.class, Junction.class, Iff.class, EqS.class, UneqS.class}, (Object)constraint2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Falsehood f = (Falsehood)constraint2;
                yield 1;
            }
            case 1 -> {
                Truth t = (Truth)constraint2;
                yield 1;
            }
            case 2 -> {
                BVar x = (BVar)constraint2;
                yield 1;
            }
            case 3 -> {
                NBVar x = (NBVar)constraint2;
                yield 1;
            }
            case 4 -> {
                Comparison c = (Comparison)constraint2;
                yield 1;
            }
            case 5 -> {
                Junction junc = (Junction)constraint2;
                int c = this.symbol().compareTo(junc.symbol());
                if (c == 0) {
                    c = this._children.size() - junc.numChildren();
                }
                if (c != 0) {
                    yield c;
                }
                for (int i = 1; i <= this._children.size() && c == 0; ++i) {
                    c = this._children.get(i - 1).compareTo(junc.queryChild(i));
                }
                yield c;
            }
            case 6 -> {
                Iff i = (Iff)constraint2;
                yield -1;
            }
            case 7 -> {
                EqS e = (EqS)constraint2;
                yield -1;
            }
            case 8 -> {
                UneqS u = (UneqS)constraint2;
                yield -1;
            }
        };
    }
}

