/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.Addition;
import charlie.smt.CMult;
import charlie.smt.Division;
import charlie.smt.IValue;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.Modulo;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Multiplication
extends IntegerExpression {
    protected ArrayList<IntegerExpression> _children = new ArrayList();

    protected void addChild(IntegerExpression child) {
        IntegerExpression integerExpression = child;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Multiplication.class, CMult.class}, (Object)integerExpression2, n)) {
            case 0: {
                Multiplication c = (Multiplication)integerExpression2;
                for (int i = 1; i <= c.numChildren(); ++i) {
                    this._children.add(c.queryChild(i));
                }
                break;
            }
            case 1: {
                CMult c = (CMult)integerExpression2;
                this._children.add(new IValue(c.queryConstant()));
                this._children.add(c.queryChild());
                break;
            }
            default: {
                this._children.add(child);
            }
        }
    }

    Multiplication(IntegerExpression a, IntegerExpression b) {
        this.addChild(a);
        this.addChild(b);
        this.checkSimplified();
    }

    Multiplication(List<IntegerExpression> args) {
        for (int i = 0; i < args.size(); ++i) {
            this.addChild(args.get(i));
        }
        this.checkSimplified();
    }

    public int numChildren() {
        return this._children.size();
    }

    public IntegerExpression queryChild(int index) {
        if (index <= 0 || index > this._children.size()) {
            throw new IndexOutOfBoundsException("Multiplication::queryChild(" + index + ") called on a Multiplication with " + this._children.size() + " children! (" + this.toString() + ")");
        }
        return this._children.get(index - 1);
    }

    @Override
    public int evaluate(Valuation val) {
        int ret = 1;
        for (int i = 0; i < this._children.size() && ret != 0; ret *= this._children.get(i).evaluate(val), ++i) {
        }
        return ret;
    }

    private void checkSimplified() {
        for (int i = 0; i < this._children.size(); ++i) {
            IntegerExpression child = this._children.get(i);
            if (child instanceof IValue || child instanceof Addition) {
                return;
            }
            if (i <= 0 || this._children.get(i - 1).compareTo(child) <= 0) continue;
            return;
        }
        this._simplified = this._children.size() >= 2;
    }

    private int addSimplifiedChildren(ArrayList<IntegerExpression> from, ArrayList<IntegerExpression> to) {
        int constant = 1;
        for (IntegerExpression child : from) {
            IntegerExpression c = child.simplify();
            if (c instanceof IValue) {
                IValue k = (IValue)c;
                constant *= k.queryValue();
                continue;
            }
            if (c instanceof CMult) {
                CMult cm = (CMult)c;
                constant *= cm.queryConstant();
                to.add(cm.queryChild());
                continue;
            }
            if (c instanceof Multiplication) {
                Multiplication m = (Multiplication)c;
                constant *= this.addSimplifiedChildren(m._children, to);
                continue;
            }
            to.add(c);
        }
        return constant;
    }

    @Override
    public IntegerExpression simplify() {
        if (this._simplified) {
            return this;
        }
        ArrayList<IntegerExpression> todo = new ArrayList<IntegerExpression>();
        int constant = this.addSimplifiedChildren(this._children, todo);
        Collections.sort(todo);
        if (todo.size() == 0) {
            return new IValue(constant);
        }
        if (todo.size() == 1) {
            return todo.get(0).multiply(constant);
        }
        for (int i = 0; i < todo.size(); ++i) {
            IntegerExpression integerExpression = todo.get(i);
            if (!(integerExpression instanceof Addition)) continue;
            Addition a = (Addition)integerExpression;
            ArrayList<IntegerExpression> parts = new ArrayList<IntegerExpression>();
            for (int j = 1; j <= a.numChildren(); ++j) {
                todo.set(i, a.queryChild(j));
                parts.add(new Multiplication(todo));
            }
            return new Addition(parts).simplify();
        }
        return new Multiplication(todo).multiply(constant);
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(*");
        for (int i = 0; i < this._children.size(); ++i) {
            builder.append(" ");
            this._children.get(i).addToSmtString(builder);
        }
        builder.append(")");
    }

    @Override
    public int compareTo(IntegerExpression other) {
        IntegerExpression integerExpression = other;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, IVar.class, CMult.class, Addition.class, Multiplication.class, Division.class, Modulo.class}, (Object)integerExpression2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IValue v = (IValue)integerExpression2;
                yield 1;
            }
            case 1 -> {
                IVar x = (IVar)integerExpression2;
                yield 1;
            }
            case 2 -> {
                CMult cm = (CMult)integerExpression2;
                if (this.compareTo(cm.queryChild()) <= 0) {
                    yield -1;
                }
                yield 1;
            }
            case 3 -> {
                Addition a = (Addition)integerExpression2;
                yield 1;
            }
            case 4 -> {
                Multiplication m = (Multiplication)integerExpression2;
                int i = this._children.size();
                for (int j = m.numChildren(); i > 0 && j > 0; --i, --j) {
                    int c = this._children.get(i - 1).compareTo(m.queryChild(j));
                    if (c == 0) continue;
                    yield c;
                }
                yield this._children.size() - m.numChildren();
            }
            case 5 -> {
                Division d = (Division)integerExpression2;
                yield -1;
            }
            case 6 -> {
                Modulo m = (Modulo)integerExpression2;
                yield -1;
            }
        };
    }

    public int hashCode() {
        return 7 * this._children.hashCode() + 4;
    }
}

