/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.Falsehood;
import charlie.smt.SmtEvaluationException;
import charlie.smt.Truth;
import charlie.smt.Valuation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class NBVar
extends Constraint {
    private BVar _negated;

    NBVar(BVar x) {
        this._negated = x;
        this._simplified = true;
    }

    public int queryIndex() {
        return this._negated.queryIndex();
    }

    public String queryName() {
        return this._negated.queryName();
    }

    @Override
    public BVar negate() {
        return this._negated;
    }

    @Override
    public boolean evaluate(Valuation val) {
        if (val == null) {
            throw new SmtEvaluationException(this._negated);
        }
        return !val.queryBoolAssignment(this._negated.queryIndex());
    }

    @Override
    public NBVar simplify() {
        return this;
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(not ");
        this._negated.addToSmtString(builder);
        builder.append(")");
    }

    @Override
    public int compareTo(Constraint other) {
        Constraint constraint = other;
        Objects.requireNonNull(constraint);
        Constraint constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Falsehood.class, Truth.class, NBVar.class, BVar.class}, (Object)constraint2, n)) {
            case 0 -> {
                Falsehood f = (Falsehood)constraint2;
                yield 1;
            }
            case 1 -> {
                Truth t = (Truth)constraint2;
                yield 1;
            }
            case 2 -> {
                NBVar x = (NBVar)constraint2;
                yield this._negated.queryIndex() - x.queryIndex();
            }
            case 3 -> {
                BVar x = (BVar)constraint2;
                int ret = this._negated.queryIndex() - x.queryIndex();
                if (ret == 0) {
                    yield 1;
                }
                yield ret;
            }
            default -> -1;
        };
    }

    public int hashCode() {
        return this._negated.hashCode() + 1;
    }
}

