/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.BVar;
import charlie.smt.Conjunction;
import charlie.smt.Constraint;
import charlie.smt.ConstraintPrinter;
import charlie.smt.Disjunction;
import charlie.smt.IVar;
import charlie.smt.SVar;
import charlie.smt.Truth;
import java.util.ArrayList;
import java.util.Iterator;

public class SmtProblem
implements Iterable<Constraint> {
    private int _lastBooleanIndex = 0;
    private int _lastIntegerIndex = 0;
    private int _lastStringIndex = 0;
    private ArrayList<Constraint> _constraints = new ArrayList();

    public IVar createIntegerVariable() {
        ++this._lastIntegerIndex;
        return new IVar(this._lastIntegerIndex);
    }

    public IVar createIntegerVariable(String name) {
        ++this._lastIntegerIndex;
        return new IVar(this._lastIntegerIndex, name);
    }

    public BVar createBooleanVariable() {
        ++this._lastBooleanIndex;
        return new BVar(this._lastBooleanIndex);
    }

    public BVar createBooleanVariable(String name) {
        ++this._lastBooleanIndex;
        return new BVar(this._lastBooleanIndex, name);
    }

    public SVar createStringVariable() {
        ++this._lastStringIndex;
        return new SVar(this._lastStringIndex);
    }

    public SVar createStringVariable(String name) {
        ++this._lastStringIndex;
        return new SVar(this._lastStringIndex, name);
    }

    public void require(Constraint c) {
        this._constraints.add(c);
    }

    public void requireImplication(Constraint premise, Constraint conclusion) {
        this._constraints.add(new Disjunction(premise.negate(), conclusion));
    }

    public void clear() {
        this._constraints.clear();
    }

    public int numberIntegerVariables() {
        return this._lastIntegerIndex;
    }

    public int numberBooleanVariables() {
        return this._lastBooleanIndex;
    }

    public int numberStringVariables() {
        return this._lastStringIndex;
    }

    public int numberConstraints() {
        return this._constraints.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this._constraints.iterator();
    }

    public Constraint queryCombinedConstraint() {
        if (this._constraints.size() == 0) {
            return new Truth();
        }
        if (this._constraints.size() == 1) {
            return this._constraints.get(0);
        }
        return new Conjunction(this._constraints);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ConstraintPrinter printer = new ConstraintPrinter();
        for (int i = 0; i < this._constraints.size(); ++i) {
            printer.print(this._constraints.get(i), ret);
            ret.append("\n");
        }
        return ret.toString();
    }

    public String toString(int num) {
        StringBuilder ret = new StringBuilder();
        ConstraintPrinter printer = new ConstraintPrinter();
        int start = 0;
        int end = this._constraints.size();
        if (num > 0) {
            if (this._constraints.size() > num) {
                end = num;
            }
        } else {
            start = this._constraints.size() + num;
            if (start < 0) {
                start = 0;
            }
        }
        for (int i = start; i < end; ++i) {
            printer.print(this._constraints.get(i), ret);
            ret.append("\n");
        }
        return ret.toString();
    }
}

