/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.BVar;
import charlie.smt.IVar;
import charlie.smt.SVar;
import java.util.TreeMap;
import java.util.TreeSet;

public class Valuation {
    private TreeSet<Integer> _trueBVars = new TreeSet();
    private TreeMap<Integer, Integer> _iVarValues = new TreeMap();
    private TreeMap<Integer, String> _sVarValues = new TreeMap();

    public boolean queryBoolAssignment(int index) {
        return this._trueBVars.contains(index);
    }

    public int queryIntAssignment(int index) {
        if (this._iVarValues.containsKey(index)) {
            return this._iVarValues.get(index);
        }
        return 4242;
    }

    public String queryStringAssignment(int index) {
        if (this._sVarValues.containsKey(index)) {
            return this._sVarValues.get(index);
        }
        return "";
    }

    public boolean queryAssignment(BVar x) {
        return this.queryBoolAssignment(x.queryIndex());
    }

    public int queryAssignment(IVar x) {
        return this.queryIntAssignment(x.queryIndex());
    }

    public String queryAssignment(SVar x) {
        return this.queryStringAssignment(x.queryIndex());
    }

    public void setBool(int index, boolean value) {
        if (value) {
            this._trueBVars.add(index);
        } else {
            this._trueBVars.remove(index);
        }
    }

    public void setInt(int index, int value) {
        this._iVarValues.put(index, value);
    }

    public void setString(int index, String value) {
        this._sVarValues.put(index, value);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("True boolean variables:\n");
        for (Integer i : this._trueBVars) {
            ret.append("  b" + i.toString() + "\n");
        }
        if (this._iVarValues.size() > 0) {
            ret.append("Integer variables:\n");
        }
        for (Integer i : this._iVarValues.keySet()) {
            ret.append("  i" + i.toString() + " : " + this._iVarValues.get(i).toString() + "\n");
        }
        if (this._sVarValues.size() > 0) {
            ret.append("Stirng variables:");
        }
        for (Integer i : this._sVarValues.keySet()) {
            ret.append("  s" + i.toString() + " : " + this._sVarValues.get(i).toString() + "\n");
        }
        return ret.toString();
    }
}

