/*
 * Decompiled with CFR 0.152.
 */
package charlie.solvesmt;

import charlie.parser.lib.ParsingException;
import charlie.smt.Constraint;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.solvesmt.SExpression;
import charlie.solvesmt.SMTLibResponseHandler;
import charlie.solvesmt.SMTLibString;
import charlie.solvesmt.SmtParser;
import charlie.util.ExceptionLogger;
import charlie.util.SystemUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

public class ExternalSmtSolver
implements SmtSolver {
    private String _cmd;

    public ExternalSmtSolver(String command) {
        this._cmd = command;
    }

    public ExternalSmtSolver() {
        this._cmd = SystemUtils.IS_OS_WINDOWS ? "smtsolver.bat" : (SystemUtils.IS_UNIX_LIKE ? "./smtsolver.sh" : null);
    }

    private void createSmtFile(int numbool, int numint, int numstring, Constraint constraint, SMTLibString.Logic logic) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("problem.smt2"));
        SMTLibString file = new SMTLibString(SMTLibString.Version.V26);
        String stringOfFile = file.buildSmtlibString(numbool, numint, numstring, logic, constraint);
        writer.write(stringOfFile);
        writer.close();
    }

    private void runSmtSolver() throws IOException, InterruptedException {
        Process p;
        Runtime rt = Runtime.getRuntime();
        try {
            p = rt.exec(new String[]{"rm", "result"});
            p.waitFor();
        }
        catch (Exception p2) {
            // empty catch block
        }
        p = null;
        if (this._cmd != null) {
            p = rt.exec(new String[]{this._cmd, "problem.smt2", "result"});
        }
        if (p != null) {
            p.waitFor();
        }
    }

    private String readAnswer() throws IOException {
        File file = new File("result");
        Scanner reader = new Scanner(file);
        return SMTLibResponseHandler.readAnswer(reader);
    }

    private SmtSolver.Answer readSmtFile() throws IOException {
        List<SExpression> exprs = SmtParser.readExpressionsFromFile("result");
        return SMTLibResponseHandler.expressionsToAnswer(exprs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SmtSolver.Answer checkSatisfiability(SmtProblem problem) {
        SmtSolver.Answer ret;
        Constraint combinedConstraints = problem.queryCombinedConstraint();
        try {
            this.createSmtFile(problem.numberBooleanVariables(), problem.numberIntegerVariables(), problem.numberStringVariables(), combinedConstraints, SMTLibString.getLogic(problem));
        }
        catch (IOException e) {
            ExceptionLogger.log("Could not create SMT file: " + e.getMessage(), e);
            return new SmtSolver.Answer.MAYBE("Could not create SMT file: " + e.getMessage());
        }
        try {
            this.runSmtSolver();
        }
        catch (IOException e) {
            ExceptionLogger.log("Could not execute SMT solver: " + e.getMessage(), e);
            return new SmtSolver.Answer.MAYBE("Could not execute SMT solver: " + e.getMessage());
        }
        catch (InterruptedException e) {
            String msg = "Waiting for external SMT solver was interrupted: " + e.getMessage() + "\n(Warning: the SMT solver may still be running in the background.  If so, you may need to kill it.";
            ExceptionLogger.log(msg, e);
            return new SmtSolver.Answer.MAYBE(msg);
        }
        try {
            ret = this.readSmtFile();
        }
        catch (IOException e) {
            ExceptionLogger.log("Error reading SMT solver result file: " + e.getMessage(), e);
            return new SmtSolver.Answer.MAYBE("Error reading result file: " + e.getMessage());
        }
        catch (ParsingException e) {
            ExceptionLogger.log("Parsing error reading result file: " + e.getMessage(), e);
            return new SmtSolver.Answer.MAYBE("Parsing error reading result file: " + e.getMessage());
        }
        SmtSolver.Answer answer = ret;
        Objects.requireNonNull(answer);
        SmtSolver.Answer answer2 = answer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmtSolver.Answer.YES.class}, (Object)answer2, n)) {
            case 0: {
                SmtSolver.Answer.YES yES = (SmtSolver.Answer.YES)answer2;
                try {
                    Valuation valuation;
                    Valuation val = valuation = yES.val();
                    if (combinedConstraints.evaluate(val)) return ret;
                    return new SmtSolver.Answer.MAYBE("Valuation read from external solver does not satisfy the constraint!");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean checkValidity(SmtProblem problem) {
        Constraint negated = SmtFactory.createNegation(problem.queryCombinedConstraint());
        try {
            this.createSmtFile(problem.numberBooleanVariables(), problem.numberIntegerVariables(), problem.numberStringVariables(), negated, SMTLibString.getLogic(problem));
            this.runSmtSolver();
            return this.readAnswer().equals("unsat");
        }
        catch (Exception e) {
            ExceptionLogger.log(e);
            return false;
        }
    }
}

