/*
 * Decompiled with CFR 0.152.
 */
package charlie.solvesmt;

import charlie.smt.Constraint;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.solvesmt.SExpression;
import charlie.solvesmt.SMTLibResponseHandler;
import charlie.solvesmt.SMTLibString;
import charlie.solvesmt.SmtParser;
import charlie.util.ExceptionLogger;
import charlie.util.NullStorageException;
import charlie.util.ProcessCaller;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;

public class ProcessSmtSolver
implements SmtSolver {
    public static int TIMEOUT = 10;
    private final PhysicalSolver _physicalSolver;

    public static PhysicalSolver stringToSolver(String name) {
        if ((name = name.toLowerCase()).equals("z3")) {
            return PhysicalSolver.Z3;
        }
        if (name.equals("cvc5") || name.equals("cvc")) {
            return PhysicalSolver.CVC5;
        }
        if (name.equals("yices2") || name.equals("yices")) {
            return PhysicalSolver.YICES2;
        }
        return null;
    }

    public ProcessSmtSolver() {
        this._physicalSolver = PhysicalSolver.Z3;
    }

    public ProcessSmtSolver(PhysicalSolver physicalSolver) {
        if (physicalSolver == null) {
            throw new NullStorageException("ProcessSmtSolver", "Cannot initialise a null Physical Solver");
        }
        this._physicalSolver = physicalSolver;
    }

    private ProcessCaller createSmtSolverProcess(Path smtProblemFile, int timeout) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this._physicalSolver.getCommandName() + " " + smtProblemFile.toString());
        return new ProcessCaller(commands, timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SmtSolver.Answer checkSatisfiability(SmtProblem problem) {
        SmtSolver.Answer ret;
        String smtResultString;
        SMTLibString file = new SMTLibString(SMTLibString.Version.V26);
        String stringOfSmtProblem = file.buildSmtlibString(problem);
        try {
            Path smtProblemFile = Files.createTempFile("coraSMTTask_sat_", null, new FileAttribute[0]);
            Files.writeString(smtProblemFile, (CharSequence)stringOfSmtProblem, new OpenOption[0]);
            ProcessCaller pc = this.createSmtSolverProcess(smtProblemFile, TIMEOUT);
            Optional<String> optionalSmtResultString = pc.getResultAsString();
            Files.delete(smtProblemFile);
            if (!optionalSmtResultString.isPresent()) {
                return new SmtSolver.Answer.MAYBE("SMT solver process did not return an answer within the time limit.");
            }
            smtResultString = optionalSmtResultString.get();
        }
        catch (Exception e) {
            ExceptionLogger.log(e);
            return new SmtSolver.Answer.MAYBE("External SMT process failed: " + e.getMessage());
        }
        List<SExpression> parsedResults = SmtParser.readExpressionsFromString(smtResultString);
        SmtSolver.Answer answer = ret = SMTLibResponseHandler.expressionsToAnswer(parsedResults);
        Objects.requireNonNull(answer);
        SmtSolver.Answer answer2 = answer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmtSolver.Answer.YES.class}, (Object)answer2, n)) {
            case 0: {
                SmtSolver.Answer.YES yES = (SmtSolver.Answer.YES)answer2;
                try {
                    Valuation valuation;
                    Valuation val = valuation = yES.val();
                    if (problem.queryCombinedConstraint().evaluate(val)) return ret;
                    return new SmtSolver.Answer.MAYBE("Valuation read from external solver does not satisfy the constraints posed on the smt problem!");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean checkValidity(SmtProblem problem) {
        SMTLibString file = new SMTLibString(SMTLibString.Version.V26);
        Constraint negated = SmtFactory.createNegation(problem.queryCombinedConstraint());
        String stringOfSmtProblem = file.buildSmtlibString(problem.numberBooleanVariables(), problem.numberIntegerVariables(), problem.numberStringVariables(), SMTLibString.getLogic(problem), negated);
        try {
            Path smtProblemFile = Files.createTempFile("coraSMTTask_validity_", null, new FileAttribute[0]);
            Files.writeString(smtProblemFile, (CharSequence)stringOfSmtProblem, new OpenOption[0]);
            ProcessCaller pc = this.createSmtSolverProcess(smtProblemFile, TIMEOUT);
            Optional<InputStream> is = pc.getResultAsInputStream();
            Files.delete(smtProblemFile);
            if (is.isPresent()) {
                Scanner scanner = new Scanner(is.get());
                return SMTLibResponseHandler.readAnswer(scanner).equals("unsat");
            }
        }
        catch (Exception e) {
            ExceptionLogger.log(e);
            return false;
        }
        return false;
    }

    public static enum PhysicalSolver {
        Z3,
        YICES2,
        CVC5;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Z3";
                case 1 -> "YICES 2";
                case 2 -> "CvC 5";
            };
        }

        public String getCommandName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "z3";
                case 2 -> "cvc";
                case 1 -> "yices-smt2";
            };
        }
    }
}

