/*
 * Decompiled with CFR 0.152.
 */
package charlie.solvesmt;

import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.solvesmt.SExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

class SMTLibResponseHandler {
    SMTLibResponseHandler() {
    }

    static String readAnswer(Scanner reader) {
        if (!reader.hasNextLine()) {
            return null;
        }
        String answer = reader.nextLine();
        reader.close();
        if (answer.toLowerCase().equals("unsat")) {
            return "unsat";
        }
        if (!answer.toLowerCase().equals("sat")) {
            return "sat";
        }
        return answer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SmtSolver.Answer expressionsToAnswer(List<SExpression> exprs) {
        if (exprs.size() == 0) {
            return new SmtSolver.Answer.MAYBE("SMT solver returned empty expression list");
        }
        SExpression sExpression = exprs.get(0);
        Objects.requireNonNull(sExpression);
        SExpression sExpression2 = sExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SExpression.Symbol.class}, (Object)sExpression2, n)) {
            case 0: {
                SExpression.Symbol symbol = (SExpression.Symbol)sExpression2;
                try {
                    String string;
                    String answer = string = symbol.name();
                    if (answer.toLowerCase().equals("unsat")) {
                        return new SmtSolver.Answer.NO();
                    }
                    if (!answer.toLowerCase().equals("sat")) {
                        return new SmtSolver.Answer.MAYBE("SMT solver returned: " + answer);
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            default: {
                return new SmtSolver.Answer.MAYBE("SMT solver returned expression rather than sat/unsat: " + exprs.get(0).toString());
            }
        }
        Valuation val = new Valuation();
        Iterator<SExpression> iterator = exprs.subList(1, exprs.size()).iterator();
        while (iterator.hasNext()) {
            SExpression e = iterator.next();
            SMTLibResponseHandler.addAssignments(e, val);
        }
        return new SmtSolver.Answer.YES(val);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addAssignments(SExpression expr, Valuation val) {
        String name;
        List<SExpression> lst;
        Object object;
        block18: {
            Object value = null;
            SExpression sExpression = expr;
            Objects.requireNonNull(sExpression);
            SExpression sExpression2 = sExpression;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SExpression.Symbol.class, SExpression.Numeral.class, SExpression.StringConstant.class, SExpression.SExpList.class}, (Object)sExpression2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    SExpression.Symbol x = (SExpression.Symbol)sExpression2;
                    return;
                }
                case 1: {
                    SExpression.Numeral x = (SExpression.Numeral)sExpression2;
                    return;
                }
                case 2: {
                    SExpression.StringConstant x = (SExpression.StringConstant)sExpression2;
                    return;
                }
                case 3: 
            }
            SExpression.SExpList sExpList = (SExpression.SExpList)sExpression2;
            try {
                object = sExpList.lst();
                lst = object;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (lst.size() == 3 && (object = lst.get(0)) instanceof SExpression.Symbol) {
                String string;
                String string2;
                SExpression.Symbol symbol = (SExpression.Symbol)object;
                String symb = string2 = symbol.name();
                if (!symb.equals("=")) break block18;
                SExpression sExpression3 = lst.get(1);
                if (sExpression3 instanceof SExpression.Symbol) {
                    String string3;
                    object = (SExpression.Symbol)sExpression3;
                    name = string3 = ((SExpression.Symbol)object).name();
                    SMTLibResponseHandler.addAssignment(name, lst.get(2), val);
                    return;
                }
                sExpression3 = lst.get(2);
                if (!(sExpression3 instanceof SExpression.Symbol)) return;
                object = (SExpression.Symbol)sExpression3;
                name = string = ((SExpression.Symbol)object).name();
                SMTLibResponseHandler.addAssignment(name, lst.get(1), val);
                return;
            }
        }
        if (lst.size() == 5 && (object = lst.get(0)) instanceof SExpression.Symbol) {
            SExpression.Symbol symbol = (SExpression.Symbol)object;
            String symb = name = symbol.name();
            if (symb.equals("define-fun") && (object = lst.get(1)) instanceof SExpression.Symbol) {
                SExpression.Symbol symbol2 = (SExpression.Symbol)object;
                String n = name = symbol2.name();
                SMTLibResponseHandler.addAssignment(n, lst.get(4), val);
                return;
            }
        }
        for (SExpression e : lst) {
            SMTLibResponseHandler.addAssignments(e, val);
        }
        return;
    }

    private static void addAssignment(String varname, SExpression result, Valuation val) {
        block22: {
            String string;
            Record record;
            int index;
            block23: {
                int n;
                String string2;
                SExpression sExpression;
                int kind;
                block21: {
                    String string3;
                    block20: {
                        if (varname.isEmpty()) {
                            return;
                        }
                        if (varname.charAt(0) == 'b') {
                            kind = 1;
                        } else if (varname.charAt(0) == 'i') {
                            kind = 2;
                        } else if (varname.charAt(0) == 's') {
                            kind = 3;
                        } else {
                            return;
                        }
                        try {
                            index = Integer.parseInt(varname.substring(1));
                        }
                        catch (NumberFormatException e) {
                            return;
                        }
                        if (kind != 1) break block21;
                        if (result instanceof SExpression.Symbol) {
                            record = (SExpression.Symbol)result;
                            String str = string3 = ((SExpression.Symbol)record).name();
                            if (!str.equals("true")) break block20;
                            val.setBool(index, true);
                        }
                    }
                    if (!(result instanceof SExpression.Symbol)) break block22;
                    SExpression.Symbol symbol = (SExpression.Symbol)result;
                    try {
                        String str = string3 = symbol.name();
                        if (str.equals("false")) {
                            val.setBool(index, false);
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                if (kind != 2) break block23;
                if (result instanceof SExpression.Numeral) {
                    int n2;
                    record = (SExpression.Numeral)result;
                    int i = n2 = ((SExpression.Numeral)record).num();
                    val.setInt(index, i);
                }
                if (!(result instanceof SExpression.SExpList)) break block22;
                record = (SExpression.SExpList)result;
                Object object = ((SExpression.SExpList)record).lst();
                List<SExpression> lst = object;
                if (lst.size() != 2 || !((sExpression = lst.get(0)) instanceof SExpression.Symbol)) break block22;
                object = (SExpression.Symbol)sExpression;
                String name = string2 = ((SExpression.Symbol)object).name();
                if (!name.equals("-") || !((sExpression = lst.get(1)) instanceof SExpression.Numeral)) break block22;
                SExpression.Numeral numeral = (SExpression.Numeral)sExpression;
                int k = n = numeral.num();
                val.setInt(index, -k);
            }
            if (!(result instanceof SExpression.StringConstant)) break block22;
            record = (SExpression.StringConstant)result;
            String c = string = ((SExpression.StringConstant)record).text();
            val.setString(index, c);
        }
    }
}

