/*
 * Decompiled with CFR 0.152.
 */
package charlie.solvesmt;

import charlie.smt.Conjunction;
import charlie.smt.Constraint;
import charlie.smt.SmtProblem;
import java.util.ArrayList;

class SMTLibString {
    private Version _version;
    private Logic _logic;

    public SMTLibString(Version version) {
        this._version = version;
    }

    public Version getVersion() {
        return this._version;
    }

    public static String versionToString(Version version) {
        return switch (version.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "2.5";
            case 1 -> "2.6";
        };
    }

    public static String logicToString(Logic logic) {
        return switch (logic.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "QF_LIA";
            case 1 -> "QF_NIA";
            case 2 -> "QF_SNIA";
        };
    }

    public static Logic getLogic(SmtProblem problem) {
        if (problem.numberStringVariables() > 0) {
            return Logic.QFSNIA;
        }
        return Logic.QFNIA;
    }

    private String setVersionString() {
        return "(set-info :smt-lib-version " + SMTLibString.versionToString(this.getVersion()) + ")";
    }

    private String setLogicString(Logic logic) {
        return "(set-logic " + SMTLibString.logicToString(logic) + ")";
    }

    public String buildSmtlibString(int boolCounter, int intCounter, int stringCounter, Logic logic, Constraint constraint) {
        int i;
        StringBuilder ret = new StringBuilder();
        ret.append(this.setVersionString()).append(System.lineSeparator());
        ret.append(this.setLogicString(logic)).append(System.lineSeparator());
        for (i = 1; i <= boolCounter; ++i) {
            ret.append("(declare-fun b").append(i).append("() Bool)").append(System.lineSeparator());
        }
        for (i = 1; i <= intCounter; ++i) {
            ret.append("(declare-fun i").append(i).append("() Int)").append(System.lineSeparator());
        }
        for (i = 1; i <= stringCounter; ++i) {
            ret.append("(declare-fun s").append(i).append("() String)").append(System.lineSeparator());
        }
        ArrayList<Constraint> acc = new ArrayList<Constraint>();
        if (constraint instanceof Conjunction) {
            Conjunction c = (Conjunction)constraint;
            for (int i2 = 1; i2 <= c.numChildren(); ++i2) {
                acc.add(c.queryChild(i2));
            }
        } else {
            acc.add(constraint);
        }
        for (Constraint c : acc) {
            ret.append("(assert ");
            c.addToSmtString(ret);
            ret.append(")").append(System.lineSeparator());
        }
        ret.append("(check-sat)").append(System.lineSeparator());
        ret.append("(get-model)").append(System.lineSeparator());
        ret.append("(exit)").append(System.lineSeparator());
        return ret.toString();
    }

    public String buildSmtlibString(SmtProblem problem) {
        return this.buildSmtlibString(problem.numberBooleanVariables(), problem.numberIntegerVariables(), problem.numberStringVariables(), SMTLibString.getLogic(problem), problem.queryCombinedConstraint());
    }

    public static enum Version {
        V25,
        V26;

    }

    public static enum Logic {
        QFLIA,
        QFNIA,
        QFSNIA;

    }
}

