/*
 * Decompiled with CFR 0.152.
 */
package charlie.solvesmt;

import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.solvesmt.SExpression;
import charlie.solvesmt.SmtTokenData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class SmtParser {
    private ParsingStatus _status;

    private SmtParser(ParsingStatus status) {
        this._status = status;
    }

    private String getUnicodeSubstring(String txt, int pos) {
        if (pos >= txt.length()) {
            return null;
        }
        if (txt.charAt(pos) == '{') {
            for (int i = pos + 1; i < txt.length(); ++i) {
                if (txt.charAt(i) != '}') continue;
                return txt.substring(pos, i + 1);
            }
            return null;
        }
        if (pos + 4 > txt.length()) {
            return null;
        }
        return txt.substring(pos, pos + 4);
    }

    private String doTranslate(String unicode) {
        if (unicode.charAt(0) == '{') {
            unicode = unicode.substring(1, unicode.length() - 1);
        }
        int code = 0;
        for (int i = 0; i < unicode.length(); ++i) {
            char c = unicode.charAt(i);
            code = code * 16 + c;
            if ('0' <= c && c <= '9') {
                code -= 48;
                continue;
            }
            if ('a' <= c && c <= 'f') {
                code -= 87;
                continue;
            }
            if ('A' <= c && c <= 'F') {
                code -= 55;
                continue;
            }
            return null;
        }
        return "" + (char)code;
    }

    private String translateUnicode(String txt, Token tok) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < txt.length()) {
            String transl;
            int j = txt.indexOf("\\u", i);
            if (j == -1) {
                builder.append(txt.substring(i));
                return builder.toString();
            }
            builder.append(txt.substring(i, j));
            String unistring = this.getUnicodeSubstring(txt, j + 2);
            String string = transl = unistring == null || unistring.length() == 0 ? null : this.doTranslate(unistring);
            if (transl == null) {
                this._status.storeError(tok, "Poorly formed string constant: " + txt.substring(j));
                return builder.toString();
            }
            builder.append(transl);
            i = j + 2 + unistring.length();
        }
        return builder.toString();
    }

    public SExpression readExpression() {
        Token tok = this._status.readNextIf(SmtTokenData.NUMERAL);
        if (tok != null) {
            try {
                return new SExpression.Numeral(Integer.parseInt(tok.getText()));
            }
            catch (NumberFormatException e) {
                return new SExpression.Symbol(tok.getText());
            }
        }
        tok = this._status.readNextIf(SmtTokenData.STRING);
        if (tok != null) {
            return new SExpression.StringConstant(this.translateUnicode(tok.getText(), tok));
        }
        tok = this._status.readNextIf(SmtTokenData.IDENTIFIER);
        if (tok != null) {
            return new SExpression.Symbol(tok.getText());
        }
        tok = this._status.readNextIf(SmtTokenData.BRACKETOPEN);
        if (tok != null) {
            List<SExpression> parts = this.readExpressions();
            this._status.expect(SmtTokenData.BRACKETCLOSE, "closing bracket");
            return new SExpression.SExpList(parts);
        }
        tok = this._status.nextToken();
        this._status.storeError(tok, "Unexpected token: expected numeral, identifier or bracketed list.");
        return new SExpression.Symbol(tok.getText());
    }

    public List<SExpression> readExpressions() {
        ArrayList<SExpression> ret = new ArrayList<SExpression>();
        while (!this._status.peekNext().isEof() && !this._status.peekNext().getName().equals(SmtTokenData.BRACKETCLOSE)) {
            ret.add(this.readExpression());
        }
        return ret;
    }

    public static SExpression readExpressionFromString(String str) {
        ParsingStatus status = new ParsingStatus(SmtTokenData.getStringLexer(str), 1);
        SmtParser parser = new SmtParser(status);
        SExpression ret = parser.readExpression();
        status.expect(Token.EOF, "end of input");
        status.throwCollectedErrors();
        return ret;
    }

    public static List<SExpression> readExpressionsFromString(String str) {
        ParsingStatus status = new ParsingStatus(SmtTokenData.getStringLexer(str), 1);
        SmtParser parser = new SmtParser(status);
        List<SExpression> ret = parser.readExpressions();
        status.expect(Token.EOF, "end of input");
        status.throwCollectedErrors();
        return ret;
    }

    public static List<SExpression> readExpressionsFromFile(String filename) throws IOException {
        ParsingStatus status = new ParsingStatus(SmtTokenData.getFileLexer(filename), 1);
        SmtParser parser = new SmtParser(status);
        List<SExpression> ret = parser.readExpressions();
        status.expect(Token.EOF, "end of file");
        status.throwCollectedErrors();
        return ret;
    }
}

