/*
 * Decompiled with CFR 0.152.
 */
package charlie.solvesmt;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.Lexer;
import charlie.parser.lib.LexerFactory;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenQueue;
import java.io.IOException;

class SmtTokenData {
    public static String NUMERAL = "NUMERAL";
    public static String STRING = "STRING";
    public static String IDENTIFIER = "IDENTIFIER";
    public static String BRACKETOPEN = "BRACKETOPEN";
    public static String BRACKETCLOSE = "BRACKETCLOSE";
    public static String[] tokens = new String[]{"unsupported", Token.SKIP, "0|([1-9][0-9]*)", NUMERAL, "[^\\s();\"]+", IDENTIFIER, "\"", STRING, "\\(", BRACKETOPEN, "\\)", BRACKETCLOSE, "\\s", Token.SKIP, ";.*$", Token.SKIP};

    SmtTokenData() {
    }

    private static TokenQueue makeTokenQueue(ChangeableLexer clexer) {
        Lexer lexer = LexerFactory.createLongTokenLexer(clexer, STRING, "[^\"]+|\"\"", "\"", STRING);
        lexer = LexerFactory.createStringEditLexer(lexer, STRING, new String[]{"\"\"", "\""}, '\u0000');
        lexer = LexerFactory.createErrorLexer(lexer, "ILLEGAL", "Illegal token: @TEXT@.");
        return LexerFactory.createPushbackLexer(lexer);
    }

    public static TokenQueue getFileLexer(String filename) throws IOException {
        return SmtTokenData.makeTokenQueue(LexerFactory.createFileLexer(tokens, filename));
    }

    public static TokenQueue getStringLexer(String text) {
        return SmtTokenData.makeTokenQueue(LexerFactory.createStringLexer(tokens, text));
    }
}

