/*
 * Decompiled with CFR 0.152.
 */
package charlie.substitution;

import charlie.substitution.MutableSubstitution;
import charlie.substitution.PatternRequiredException;
import charlie.substitution.Substitution;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.util.UserException;
import java.util.ArrayList;
import java.util.TreeSet;

public class Matcher {
    public static MutableSubstitution match(Term pattern, Term instance) {
        MutableSubstitution ret = new MutableSubstitution();
        if (Matcher.extendMatch(pattern, instance, ret) == null) {
            return ret;
        }
        return null;
    }

    public static MatchFailure extendMatch(Term pattern, Term instance, MutableSubstitution subst) {
        if (pattern.isVariable()) {
            return Matcher.extendMatchWithVariable(pattern.queryVariable(), instance, subst);
        }
        if (pattern.isMetaApplication()) {
            return Matcher.extendMatchWithMeta(pattern, instance, subst);
        }
        if (pattern.isConstant()) {
            return Matcher.checkMatchWithConstant(pattern, instance);
        }
        if (pattern.isApplication()) {
            return Matcher.extendMatchWithApplication(pattern, instance, subst);
        }
        if (pattern.isTuple()) {
            return Matcher.extendMatchWithTuple(pattern, instance, subst);
        }
        if (pattern.isAbstraction()) {
            return Matcher.extendMatchWithAbstraction(pattern, instance, subst);
        }
        throw new IllegalArgumentException("Matcher::extendMatch called with a term that does not have any of the standard term shapes!");
    }

    private static MatchFailure extendMatchWithVariable(Variable x, Term instance, MutableSubstitution gamma) {
        Term previous = gamma.get(x);
        if (previous == null) {
            if (!instance.queryType().equals(x.queryType())) {
                return new MatchFailure("Variable ", x, " has a different type from ", instance, ".");
            }
            gamma.extend(x, instance);
            return null;
        }
        if (previous.equals(instance)) {
            return null;
        }
        return new MatchFailure(x.isBinderVariable() ? "Binder variable " : "Variable ", x, " is mapped both to ", previous, " and to ", instance, ".");
    }

    private static MatchFailure extendMatchWithMeta(Term metaApp, Term instance, MutableSubstitution gamma) {
        ArrayList<Variable> substitutedArgs = Matcher.checkMetaPattern(metaApp, gamma);
        Term ret = instance;
        for (int i = substitutedArgs.size() - 1; i >= 0; --i) {
            ret = TermFactory.createAbstraction(substitutedArgs.get(i), ret);
        }
        MetaVariable metavar = metaApp.queryMetaVariable();
        Term previous = gamma.get(metavar);
        if (previous == null) {
            if (!instance.queryType().equals(metaApp.queryType())) {
                return new MatchFailure("Cannot match ", metaApp, " against ", instance, " as types do not match.");
            }
            gamma.extend(metavar, ret);
            return null;
        }
        if (previous.equals(ret)) {
            return null;
        }
        return new MatchFailure("Meta-variable ", metavar, " is mapped to both ", previous, " and to ", ret, ".");
    }

    private static ArrayList<Variable> checkMetaPattern(Term metaApp, Substitution gamma) {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        TreeSet<Variable> sofar = new TreeSet<Variable>();
        for (int i = 1; i <= metaApp.numberMetaArguments(); ++i) {
            if (!metaApp.queryMetaArgument(i).isVariable()) {
                throw new PatternRequiredException(metaApp, "matching", i + 1, "is not a variable (let alone a bound variable)");
            }
            Variable x = metaApp.queryMetaArgument(i).queryVariable();
            if (!x.isBinderVariable()) {
                throw new PatternRequiredException(metaApp, "matching", i + 1, "is not a binder variable.");
            }
            Term replacement = gamma.get(x);
            if (replacement == null) {
                throw new PatternRequiredException(metaApp, "matching", i + 1, "is not bound in the context above this subterm.");
            }
            if (!replacement.isVariable()) {
                throw new PatternRequiredException(metaApp, "matching", i + 1, "is substituted to a non-variable term in the context.");
            }
            Variable y = replacement.queryVariable();
            if (!y.isBinderVariable()) {
                throw new PatternRequiredException(metaApp, "matching", i + 1, "is substituted to a non-binder variable in the context.");
            }
            ret.add(y);
            if (sofar.contains(y)) {
                throw new PatternRequiredException(metaApp, "matching", i + 1, "is substituted to the same binder variable as a previous argument.");
            }
            sofar.add(y);
        }
        return ret;
    }

    private static MatchFailure checkMatchWithConstant(Term symbol, Term instance) {
        if (symbol.equals(instance)) {
            return null;
        }
        return new MatchFailure("Constant ", symbol, " is not instantiated by ", instance, ".");
    }

    private static MatchFailure extendMatchWithApplication(Term pattern, Term instance, MutableSubstitution gamma) {
        if (!instance.isApplication()) {
            return new MatchFailure("The term ", instance, " does not instantiate ", pattern, " as it is not an application.");
        }
        if (instance.numberArguments() < pattern.numberArguments()) {
            return new MatchFailure("The term ", instance, " does not instantiate ", pattern, " as it has too few arguments.");
        }
        int i = instance.numberArguments();
        for (int j = pattern.numberArguments(); j > 0; --j) {
            Term inssub;
            Term patsub = pattern.queryArgument(j);
            MatchFailure warning = Matcher.extendMatch(patsub, inssub = instance.queryArgument(i), gamma);
            if (warning != null) {
                return warning;
            }
            --i;
        }
        return Matcher.extendMatch(pattern.queryHead(), instance.queryImmediateHeadSubterm(i), gamma);
    }

    private static MatchFailure extendMatchWithTuple(Term tuple, Term instance, MutableSubstitution gamma) {
        if (!instance.isTuple()) {
            return new MatchFailure("The term ", instance, " does not instantiate ", tuple, " as it is not a tuple term.");
        }
        if (tuple.numberTupleArguments() != instance.numberTupleArguments()) {
            return new MatchFailure("The term ", instance, " does not instantiate ", tuple, " as the tuple sizes are not the same.");
        }
        for (int i = 1; i <= tuple.numberTupleArguments(); ++i) {
            MatchFailure warning = Matcher.extendMatch(tuple.queryTupleArgument(i), instance.queryTupleArgument(i), gamma);
            if (warning == null) continue;
            return warning;
        }
        return null;
    }

    public static MatchFailure extendMatchWithAbstraction(Term pattern, Term instance, MutableSubstitution gamma) {
        if (!instance.isAbstraction()) {
            return new MatchFailure("Abstraction ", pattern, " is not instantiated by ", instance, ".");
        }
        Variable x = pattern.queryVariable();
        Variable y = instance.queryVariable();
        Term backup = gamma.get(x);
        if (backup == null) {
            gamma.extend(x, y);
        } else {
            gamma.replace(x, y);
        }
        MatchFailure ret = Matcher.extendMatch(pattern.queryAbstractionSubterm(), instance.queryAbstractionSubterm(), gamma);
        if (backup == null) {
            gamma.delete(x);
        } else {
            gamma.replace(x, backup);
        }
        if (ret != null) {
            return ret;
        }
        for (Replaceable z : pattern.freeReplaceables()) {
            Term gammaz = gamma.get(z);
            if (gammaz == null || !gammaz.freeReplaceables().contains(y)) continue;
            return new MatchFailure("Abstraction ", pattern, " is not instantiated by ", instance, " because the induced mapping [", z, " := ", gammaz, "] contains the binder variable of ", instance, ".");
        }
        return null;
    }

    public static class MatchFailure
    extends UserException {
        public MatchFailure(Object ... args) {
            super(args);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }
}

