/*
 * Decompiled with CFR 0.152.
 */
package charlie.substitution;

import charlie.substitution.ImmutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TypingException;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.util.NullStorageException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class MutableSubstitution
implements Substitution {
    private final HashMap<Replaceable, Term> _mapping;

    public MutableSubstitution() {
        this._mapping = new HashMap();
    }

    public MutableSubstitution(Replaceable key, Term value) {
        this._mapping = new HashMap();
        this.extend(key, value);
    }

    private MutableSubstitution(MutableSubstitution copyme) {
        this._mapping = new HashMap<Replaceable, Term>(copyme._mapping);
    }

    @Override
    public MutableSubstitution copy() {
        return new MutableSubstitution(this);
    }

    @Override
    public Term get(Replaceable x) {
        return this._mapping.get(x);
    }

    @Override
    public Term getReplacement(Replaceable x) {
        Term ret = this._mapping.get(x);
        if (ret != null) {
            return ret;
        }
        return TermFactory.makeTerm(x);
    }

    public boolean extend(Replaceable key, Term value) {
        if (key == null) {
            throw new NullStorageException("MutableSubstitution", "key");
        }
        if (value == null) {
            throw new NullStorageException("MutableSubstitution", "value");
        }
        if (!key.queryType().equals(value.queryType())) {
            throw new TypingException("Cannot map key ", key, " (of type ", key.queryType(), ") to value ", value, " (of type ", value.queryType(), ") in substitution.");
        }
        int a = key.queryArity();
        if (a > 0) {
            Term tmp = value;
            while (a > 0) {
                if (!tmp.isAbstraction()) {
                    throw new TypingException("Cannot map meta-variable ", key, " (with arity " + key.queryArity() + ") to value ", value, " in substitution: the value should be an abstraction with at least " + key.queryArity() + " abstracted variables.");
                }
                --a;
                tmp = tmp.queryAbstractionSubterm();
            }
        }
        if (this._mapping.get(key) != null) {
            return false;
        }
        this._mapping.put(key, value);
        return true;
    }

    public boolean replace(Replaceable key, Term value) {
        boolean overriding;
        boolean bl = overriding = !this.extend(key, value);
        if (overriding) {
            this._mapping.put(key, value);
        }
        return overriding;
    }

    public void delete(Replaceable key) {
        this._mapping.remove(key);
    }

    public void combine(Substitution delta) {
        for (Replaceable x : this._mapping.keySet()) {
            this._mapping.put(x, delta.substitute(this._mapping.get(x)));
        }
        for (Replaceable y : delta.domain()) {
            if (this._mapping.containsKey(y)) continue;
            this._mapping.put(y, delta.get(y));
        }
    }

    @Override
    public Set<Replaceable> domain() {
        return this._mapping.keySet();
    }

    public String toString() {
        return this._mapping.toString();
    }

    @Override
    public Term substitute(Term term) {
        if (term.isVariable()) {
            return this.getReplacement(term.queryVariable());
        }
        if (term.isConstant()) {
            return term;
        }
        if (term.isMetaApplication()) {
            return this.substituteMetaApplication(term.queryMetaVariable(), term.queryMetaArguments());
        }
        if (term.isApplication()) {
            return this.substituteApplication(term.queryHead(), term.queryArguments());
        }
        if (term.isTuple()) {
            return this.substituteTuple(term.queryTupleArguments());
        }
        if (term.isAbstraction()) {
            return this.substituteAbstraction(term.queryVariable(), term.queryAbstractionSubterm());
        }
        throw new IllegalArgumentException("Substitution::substitute called with a term that does not have any of the standard term shapes!");
    }

    private Term substituteMetaApplication(MetaVariable z, ArrayList<Term> args) {
        for (int i = 0; i < args.size(); ++i) {
            args.set(i, this.substitute(args.get(i)));
        }
        Term value = this._mapping.get(z);
        if (value == null) {
            return TermFactory.createMeta(z, args);
        }
        MutableSubstitution delta = new MutableSubstitution();
        for (int i = 0; i < args.size(); ++i) {
            if (!value.isAbstraction()) {
                throw new TypingException("Arity error when trying to substitute ", z, " by ", value, ": meta-variable takes " + args.size() + " arguments, so there should be at least this many abstractions!");
            }
            Variable x = value.queryVariable();
            value = value.queryAbstractionSubterm();
            delta.replace(x, args.get(i));
        }
        return delta.substitute(value);
    }

    private Term substituteApplication(Term head, ArrayList<Term> args) {
        head = this.substitute(head);
        for (int i = 0; i < args.size(); ++i) {
            args.set(i, this.substitute(args.get(i)));
        }
        return head.apply(args);
    }

    private Term substituteTuple(ArrayList<Term> args) {
        for (int i = 0; i < args.size(); ++i) {
            args.set(i, this.substitute(args.get(i)));
        }
        return TermFactory.createTuple(args);
    }

    private Term substituteAbstraction(Variable binder, Term subterm) {
        Variable freshvar = TermFactory.createBinder(binder.queryName(), binder.queryType());
        Term previous = this._mapping.get(binder);
        this._mapping.put(binder, freshvar);
        Term subtermSubstitute = this.substitute(subterm);
        if (previous == null) {
            this._mapping.remove(binder);
        } else {
            this._mapping.put(binder, previous);
        }
        return TermFactory.createAbstraction(freshvar, subtermSubstitute);
    }

    @Override
    public Substitution makeImmutable() {
        return new ImmutableSubstitution(this);
    }
}

