/*
 * Decompiled with CFR 0.152.
 */
package charlie.substitution;

import charlie.substitution.MutableSubstitution;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.util.Pair;
import java.util.LinkedList;
import java.util.ListIterator;

public class Unifier {
    private final LinkedList<Pair<Term, Term>> _equations = new LinkedList();
    private final MutableSubstitution _partialMgu = new MutableSubstitution();

    private Unifier() {
    }

    private boolean eliminateVariable(Variable x, Term t) {
        if (t.vars().contains(x)) {
            return false;
        }
        MutableSubstitution sub = new MutableSubstitution(x, t);
        ListIterator<Pair<Term, Term>> iter = this._equations.listIterator();
        while (iter.hasNext()) {
            Pair equ = (Pair)iter.next();
            iter.set(new Pair<Term, Term>(sub.substitute((Term)equ.fst()), sub.substitute((Term)equ.snd())));
        }
        for (Replaceable y : this._partialMgu.domain()) {
            this._partialMgu.replace(y, sub.substitute(this._partialMgu.get(y)));
        }
        this._partialMgu.extend(x, t);
        return true;
    }

    private void reduceTerm(Term l, Term r) {
        int i = l.numberArguments();
        int j = r.numberArguments();
        while (i > 0 && j > 0) {
            this._equations.push(new Pair<Term, Term>(l.queryArgument(i--), r.queryArgument(j--)));
        }
        this._equations.push(new Pair<Term, Term>(l.queryImmediateHeadSubterm(i), r.queryImmediateHeadSubterm(j)));
    }

    private boolean unify(Term l, Term r) {
        if (l.isVariable() || r.isVariable()) {
            if (l.equals(r)) {
                return true;
            }
            return l.isVariable() ? this.eliminateVariable(l.queryVariable(), r) : this.eliminateVariable(r.queryVariable(), l);
        }
        if (l.isApplication() && r.isApplication()) {
            this.reduceTerm(l, r);
            return true;
        }
        return l.equals(r);
    }

    public static MutableSubstitution mgu(Term t1, Term t2) {
        if (!t1.isApplicative() || !t2.isApplicative()) {
            throw new IllegalArgumentException("Currently unable to unify inapplicative terms.");
        }
        Unifier unifier = new Unifier();
        unifier._equations.push(new Pair<Term, Term>(t1, t2));
        while (!unifier._equations.isEmpty()) {
            Pair<Term, Term> equ = unifier._equations.pop();
            Term l = equ.fst();
            Term r = equ.snd();
            if (l.queryType().equals(r.queryType()) && unifier.unify(l, r)) continue;
            return null;
        }
        return unifier._partialMgu;
    }
}

