/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.Binder;
import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.InvalidPositionException;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermInherit;
import charlie.terms.Variable;
import charlie.terms.position.LambdaPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.NullStorageException;
import charlie.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

class Abstraction
extends TermInherit {
    private Variable _binder;
    private Term _subterm;
    private Type _type;

    public Abstraction(Variable binder, Term subterm) {
        if (binder == null) {
            throw new NullStorageException("Abstraction", "binder");
        }
        if (subterm == null) {
            throw new NullStorageException("Abstraction", "subterm");
        }
        if (!binder.isBinderVariable()) {
            throw new IllegalArgumentException("Trying to construct an abstraction whose binder " + binder.queryName() + " is not marked as a binder.");
        }
        if (subterm.boundVars().contains(binder)) {
            subterm = subterm.renameAndRefreshBinders(new TreeMap<Variable, Variable>());
        }
        this._binder = binder;
        this._subterm = subterm;
        this._type = TypeFactory.createArrow(binder.queryType(), subterm.queryType());
        ReplaceableList frees = subterm.freeReplaceables().remove(binder);
        ReplaceableList bounds = subterm.boundVars().add(binder);
        this.setVariables(frees, bounds);
    }

    @Override
    public Type queryType() {
        return this._type;
    }

    @Override
    public boolean isAbstraction() {
        return true;
    }

    @Override
    public boolean isTheoryTerm() {
        return this._binder.queryType().isTheoryType() && this._subterm.isTheoryTerm();
    }

    @Override
    public void storeFunctionSymbols(Set<FunctionSymbol> storage) {
        this._subterm.storeFunctionSymbols(storage);
    }

    @Override
    public Term queryAbstractionSubterm() {
        return this._subterm;
    }

    @Override
    public MetaVariable queryMetaVariable() {
        throw new InappropriatePatternDataException("Abstraction", "queryMetaVariable", "meta-variable applications or terms with meta-variable applications as the head");
    }

    @Override
    public Variable queryVariable() {
        return this._binder;
    }

    @Override
    public boolean isFirstOrder() {
        return false;
    }

    @Override
    public boolean isPattern() {
        return this._subterm.isPattern();
    }

    @Override
    public boolean isSemiPattern() {
        return this._subterm.isSemiPattern();
    }

    @Override
    public boolean isApplicative() {
        return false;
    }

    @Override
    public List<Pair<Term, Position>> querySubterms() {
        List<Pair<Term, Position>> ret = this._subterm.querySubterms();
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, new Pair<Term, LambdaPos>(ret.get(i).fst(), new LambdaPos(ret.get(i).snd())));
        }
        ret.add(new Pair<Abstraction, Position>(this, Position.empty));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Term querySubtermMain(Position pos) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LambdaPos.class}, (Object)position2, n)) {
            case 0: {
                LambdaPos lambdaPos = (LambdaPos)position2;
                try {
                    Position position3;
                    Position tail = position3 = lambdaPos.tail();
                    return this._subterm.querySubterm(tail);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new InvalidPositionException(this, pos, "querying subterm of an abstraction");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Term replaceSubtermMain(Position pos, Term replacement) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LambdaPos.class}, (Object)position2, n)) {
            case 0: {
                LambdaPos lambdaPos = (LambdaPos)position2;
                try {
                    Position position3;
                    Position tail = position3 = lambdaPos.tail();
                    return new Abstraction(this._binder, this._subterm.replaceSubterm(pos.queryTail(), replacement));
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new InvalidPositionException(this, pos, "replacing subterm of an abstraction");
    }

    @Override
    public Term renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        Binder freshvar = new Binder(this._binder.queryName(), this._binder.queryType());
        Variable previous = renaming.get(this._binder);
        renaming.put(this._binder, freshvar);
        Term subtermSubstitute = this._subterm.renameAndRefreshBinders(renaming);
        if (previous == null) {
            renaming.remove(this._binder);
        } else {
            renaming.put(this._binder, previous);
        }
        return new Abstraction(freshvar, subtermSubstitute);
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        if (!term.isAbstraction()) {
            return false;
        }
        Variable x = this._binder;
        Variable y = term.queryVariable();
        if (!x.queryType().equals(y.queryType())) {
            return false;
        }
        if (mu.containsKey(x)) {
            throw new IllegalArgumentException("Calling Abstraction::alphaEquals when mu already maps " + x.toString() + ".");
        }
        if (xi.containsKey(y)) {
            throw new IllegalArgumentException("Calling Abstraction::alphaEquals when xi already maps " + y.toString() + ".");
        }
        mu.put(x, k);
        xi.put(y, k);
        boolean retval = this._subterm.alphaEquals(term.queryAbstractionSubterm(), mu, xi, k + 1);
        mu.remove(x);
        xi.remove(y);
        return retval;
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        if (mu == null) {
            mu = new TreeMap<Variable, Integer>();
        }
        mu.put(this._binder, mu.size() + 1);
        int ret = 3 * this._subterm.hashCode(mu);
        mu.remove(this._binder);
        return ret;
    }
}

