/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.FunctionSymbol;
import charlie.terms.InvalidPositionException;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermInherit;
import charlie.terms.TypingException;
import charlie.terms.Variable;
import charlie.terms.position.ArgumentPos;
import charlie.terms.position.FinalPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Arrow;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.NullStorageException;
import charlie.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

class Application
extends TermInherit {
    public Term _head;
    public ArrayList<Term> _args;
    public Type _outputType;

    private void setupReplaceables(List<Term> args) {
        ReplaceableList frees = Application.calculateFreeReplaceablesForSubterms(args, this._head.freeReplaceables());
        ReplaceableList bounds = this._head.boundVars();
        if (bounds.size() > 0 && !bounds.getOverlap(frees).isEmpty()) {
            this._head = this._head.renameAndRefreshBinders(new TreeMap<Variable, Variable>());
            bounds = this._head.boundVars();
        }
        this._args = new ArrayList();
        bounds = Application.calculateBoundVariablesAndRefreshSubs(args, bounds, frees, this._args);
        this.setVariables(frees, bounds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void construct(Term head, List<Term> args) {
        if (head == null) {
            throw new NullStorageException("Application", "head");
        }
        Type type = head.queryType();
        block5: for (int i = 0; i < args.size(); ++i) {
            Type type2;
            Term arg = args.get(i);
            if (arg == null) {
                throw new NullStorageException("Application", "passing a null argument to " + head.toString() + ".");
            }
            Objects.requireNonNull(type);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class}, (Object)type2, n)) {
                case 0: {
                    Type out;
                    Arrow arrow = (Arrow)type2;
                    try {
                        Type type3;
                        Type inp = type3 = arrow.left();
                        out = type3 = arrow.right();
                        if (!inp.equals(arg.queryType())) {
                            throw new TypingException("Could not construct application headed by ", head, ": argument " + (i + 1) + " of the head has type ", inp, " while the given argument to be applied, ", arg, ", has type ", arg.queryType(), ".");
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    type = out;
                    continue block5;
                }
            }
            throw new TypingException("Could not construct application headed by ", head, " with " + args.size() + " arguments: the head has type " + String.valueOf(head.queryType()), ", which only permits " + i + " arguments!");
        }
        this._outputType = type;
        this._head = head;
        if (this._head.isApplication()) {
            this._head = head.queryHead();
            ArrayList<Term> newArgs = head.queryArguments();
            newArgs.addAll(args);
            args = newArgs;
        }
        this.setupReplaceables(args);
    }

    Application(Term head, Term arg) {
        ArrayList<Term> args = new ArrayList<Term>();
        args.add(arg);
        this.construct(head, args);
    }

    Application(Term head, Term arg1, Term arg2) {
        ArrayList<Term> args = new ArrayList<Term>();
        args.add(arg1);
        args.add(arg2);
        this.construct(head, args);
    }

    Application(Term head, List<Term> args) {
        if (args == null) {
            throw new NullStorageException("Application", "argument list");
        }
        if (args.size() == 0) {
            throw new IllegalArgumentException("Application::constructor --  creating an Application with no arguments.");
        }
        this.construct(head, args);
    }

    @Override
    public Type queryType() {
        return this._outputType;
    }

    @Override
    public boolean isApplication() {
        return true;
    }

    @Override
    public boolean isFunctionalTerm() {
        return this._head.isConstant();
    }

    @Override
    public boolean isVarTerm() {
        return this._head.isVariable();
    }

    @Override
    public boolean isBetaRedex() {
        return this._head.isAbstraction();
    }

    @Override
    public boolean isTheoryTerm() {
        return this._head.isTheoryTerm() && this._args.stream().allMatch(Term::isTheoryTerm);
    }

    @Override
    public void storeFunctionSymbols(Set<FunctionSymbol> storage) {
        this._head.storeFunctionSymbols(storage);
        for (Term t : this._args) {
            t.storeFunctionSymbols(storage);
        }
    }

    @Override
    public int numberArguments() {
        return this._args.size();
    }

    @Override
    public int numberMetaArguments() {
        return this._head.numberMetaArguments();
    }

    @Override
    public ArrayList<Term> queryArguments() {
        return new ArrayList<Term>(this._args);
    }

    @Override
    public ArrayList<Term> queryMetaArguments() {
        return this._head.queryMetaArguments();
    }

    @Override
    public Term queryArgument(int i) {
        if (i <= 0 || i > this._args.size()) {
            throw new IndexOutOfBoundsException("Application::queryArgument(" + i + ") called on application with " + this._args.size() + " arguments. (" + this.toString() + ")");
        }
        return this._args.get(i - 1);
    }

    @Override
    public Term queryMetaArgument(int i) {
        return this._head.queryMetaArgument(i);
    }

    @Override
    public Term queryImmediateHeadSubterm(int i) {
        if (i < 0 || i > this._args.size()) {
            throw new IndexOutOfBoundsException("Application::queryImmediateHeadSubterm(" + i + ") called on application with " + this._args.size() + " arguments (" + this.toString() + ")");
        }
        if (i == 0) {
            return this._head;
        }
        return new Application(this._head, this._args.subList(0, i));
    }

    @Override
    public Term queryAbstractionSubterm() {
        return this._head.queryAbstractionSubterm();
    }

    @Override
    public Term queryHead() {
        return this._head;
    }

    @Override
    public FunctionSymbol queryRoot() {
        return this._head.queryRoot();
    }

    @Override
    public Variable queryVariable() {
        return this._head.queryVariable();
    }

    @Override
    public MetaVariable queryMetaVariable() {
        return this._head.queryMetaVariable();
    }

    @Override
    public boolean isFirstOrder() {
        return this._head.isConstant() && this._outputType.isBaseType() && this._args.stream().allMatch(Term::isFirstOrder);
    }

    @Override
    public boolean isPattern() {
        if (!this._head.isConstant() && !this._head.isVariable()) {
            return false;
        }
        if (this._head.isVariable() && !this._head.queryVariable().isBinderVariable()) {
            return false;
        }
        return this._args.stream().allMatch(Term::isPattern);
    }

    @Override
    public boolean isSemiPattern() {
        if (!this._head.isSemiPattern()) {
            return false;
        }
        return this._args.stream().allMatch(Term::isSemiPattern);
    }

    @Override
    public boolean isApplicative() {
        if (!this._head.isApplicative()) {
            return false;
        }
        return this._args.stream().allMatch(Term::isApplicative);
    }

    @Override
    public List<Pair<Term, Position>> querySubterms() {
        List<Pair<Term, Position>> ret = this._head.querySubterms();
        ret.remove(ret.size() - 1);
        for (int i = 0; i < this._args.size(); ++i) {
            List<Pair<Term, Position>> subposses = this._args.get(i).querySubterms();
            for (int j = 0; j < subposses.size(); ++j) {
                ret.add(new Pair<Term, ArgumentPos>(subposses.get(j).fst(), new ArgumentPos(i + 1, subposses.get(j).snd())));
            }
        }
        ret.add(new Pair<Application, Position>(this, Position.empty));
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Term querySubtermMain(Position pos) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FinalPos.class, ArgumentPos.class}, (Object)position2, n)) {
            case 0: {
                FinalPos finalPos = (FinalPos)position2;
                try {
                    int n2;
                    int k = n2 = finalPos.chopcount();
                    if (k <= this._args.size()) return this._head.apply(this._args.subList(0, this._args.size() - k));
                    throw new InvalidPositionException(this, pos, "querying subterm with excessive chop count in application");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                ArgumentPos argumentPos = (ArgumentPos)position2;
                {
                    Position position3;
                    int n3;
                    int index = n3 = argumentPos.index();
                    Position tail = position3 = argumentPos.tail();
                    if (index <= this._args.size()) return this._args.get(index - 1).querySubterm(tail);
                }
                throw new InvalidPositionException(this, pos, "querying subterm in non-existing argument of application");
            }
        }
        return this._head.querySubterm(pos);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Term replaceSubtermMain(Position pos, Term replacement) {
        v0 = pos;
        Objects.requireNonNull(v0);
        var3_3 = v0;
        var4_5 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FinalPos.class, ArgumentPos.class}, (Object)var3_3, var4_5)) {
            case 0: {
                var5_6 = (FinalPos)var3_3;
                k = var7_7 = var5_6.chopcount();
                if (k <= this._args.size()) ** GOTO lbl13
                throw new InvalidPositionException(this, pos, "replacing subterm with excessive chop count in application");
lbl13:
                // 1 sources

                type = this.queryType();
                for (i = 1; i <= k; ++i) {
                    type = TypeFactory.createArrow(this._args.get(this._args.size() - i).queryType(), type);
                }
                if (!type.equals(replacement.queryType())) {
                    t = k == 0 ? this : (k == this._args.size() ? this._head : new Application(this._head, this._args.subList(0, this._args.size() - k)));
                    throw new TypingException(new Object[]{"Typing error when replacing a subterm: I cannot replace ", t, " by ", replacement, " since the former has type ", type, " while the latter has type ", replacement.queryType(), "."});
                }
                return replacement.apply(this._args.subList(this._args.size() - k, this._args.size()));
            }
            case 1: {
                var8_12 = (ArgumentPos)var3_3;
                index = var11_13 = var8_12.index();
                tail = var11_14 = var8_12.tail();
                if (index <= this._args.size()) ** GOTO lbl29
                throw new InvalidPositionException(this, pos, "replacing subterm in non-existing argument of application");
lbl29:
                // 1 sources

                tmp = this._args.get(index - 1);
                this._args.set(index - 1, tmp.replaceSubterm(tail, replacement));
                ret = new Application(this._head, this._args);
                this._args.set(index - 1, tmp);
                return ret;
            }
        }
        newhead = this._head.replaceSubterm(pos, replacement);
        return new Application(newhead, this._args);
        catch (Throwable var3_4) {
            throw new MatchException(var3_4.toString(), var3_4);
        }
    }

    @Override
    public Term renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        Term head = this._head.renameAndRefreshBinders(renaming);
        ArrayList<Term> args = new ArrayList<Term>(this._args);
        boolean changed = head != this._head;
        for (int i = 0; i < args.size(); ++i) {
            Term other = args.get(i).renameAndRefreshBinders(renaming);
            if (other == args.get(i)) continue;
            changed = true;
            args.set(i, other);
        }
        if (!changed) {
            return this;
        }
        return new Application(head, args);
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        if (!term.isApplication()) {
            return false;
        }
        if (!this._head.alphaEquals(term.queryHead(), mu, xi, k)) {
            return false;
        }
        if (this._args.size() != term.numberArguments()) {
            return false;
        }
        for (int i = 0; i < this._args.size(); ++i) {
            if (this._args.get(i).alphaEquals(term.queryArgument(i + 1), mu, xi, k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        int ret = this._head.hashCode(mu);
        for (int i = 0; i < this._args.size(); ++i) {
            ret = 31 * ret + this._args.get(i).hashCode(mu);
        }
        return ret;
    }
}

