/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.InappropriatePatternDataException;
import charlie.terms.LeafTermInherit;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TypingException;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import charlie.util.NullStorageException;
import java.util.Map;

final class Binder
extends LeafTermInherit
implements Variable {
    private static int COUNTER = 0;
    private final String _name;
    private final int _index;

    Binder(String name, Type type) {
        super(type);
        this._name = name;
        this._index = COUNTER++;
        if (name == null) {
            throw new NullStorageException("Binder", "name");
        }
        this.setVariables(new ReplaceableList(this));
    }

    Binder(Type type) {
        super(type);
        this._name = "x{" + COUNTER + "}";
        this._index = COUNTER++;
        this.setVariables(new ReplaceableList(this));
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    @Override
    public boolean isVarTerm() {
        return true;
    }

    @Override
    public boolean isMetaApplication() {
        return false;
    }

    @Override
    public boolean isBinderVariable() {
        return true;
    }

    @Override
    public boolean isApplicative() {
        return false;
    }

    @Override
    public boolean isFirstOrder() {
        return false;
    }

    @Override
    public boolean isTheoryTerm() {
        return this.queryType().isTheoryType();
    }

    @Override
    public String queryName() {
        return this._name;
    }

    @Override
    public Replaceable.Kind queryReplaceableKind() {
        return Replaceable.Kind.BINDER;
    }

    @Override
    public int queryIndex() {
        return this._index;
    }

    @Override
    public int queryArity() {
        return 0;
    }

    @Override
    public Variable queryVariable() {
        return this;
    }

    public Term makeTerm() {
        return this;
    }

    @Override
    public MetaVariable queryMetaVariable() {
        throw new InappropriatePatternDataException("Binder", "queryMetaVariable", "meta-variable applications");
    }

    @Override
    public Variable renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        Variable ret = renaming.get(this);
        if (ret == null) {
            return this;
        }
        if (!ret.queryType().equals(this.queryType())) {
            throw new TypingException("Called renameAndRefreshBinders mapping variable ", this, " of type ", this.queryType(), " to ", ret, " of type ", ret.queryType(), ".");
        }
        return ret;
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        if (!term.isVariable()) {
            return false;
        }
        if (mu.containsKey(this)) {
            return mu.get(this).equals(xi.get(term.queryVariable()));
        }
        if (xi.containsKey(term.queryVariable())) {
            return false;
        }
        return this.equals(term.queryVariable());
    }

    @Override
    public int compareTo(Replaceable other) {
        if (other == this) {
            return 0;
        }
        int d = other.queryReplaceableKind().compareTo(this.queryReplaceableKind());
        if (d != 0) {
            return d;
        }
        if (this._index < other.queryIndex()) {
            return -1;
        }
        if (this._index > other.queryIndex()) {
            return 1;
        }
        return this.queryType().toString().compareTo(other.queryType().toString());
    }

    @Override
    public boolean equals(Replaceable other) {
        return other == this;
    }

    @Override
    public boolean equals(Variable other) {
        return other == this;
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        if (mu != null && mu.containsKey(this)) {
            return 3 * mu.get(this) + 1;
        }
        return 3 * this._index + 1;
    }
}

