/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.ValueInherit;
import charlie.terms.Variable;
import charlie.types.TypeFactory;
import java.util.Map;

class BooleanValue
extends ValueInherit {
    private final boolean _value;

    BooleanValue(boolean b) {
        super(TypeFactory.boolSort);
        this._value = b;
    }

    @Override
    public String queryName() {
        if (this._value) {
            return "true";
        }
        return "false";
    }

    @Override
    public String toUniqueString() {
        return this.queryName();
    }

    @Override
    public boolean equals(FunctionSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (!symbol.isValue()) {
            return false;
        }
        if (!symbol.queryType().equals(TypeFactory.boolSort)) {
            return false;
        }
        return symbol.toValue().getBool() == this._value;
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        return this._value ? 19 : 11;
    }

    @Override
    public boolean getBool() {
        return this._value;
    }

    @Override
    public String getString() {
        throw new InappropriatePatternDataException("BooleanValue", "getString", "string values");
    }

    @Override
    public int getInt() {
        throw new InappropriatePatternDataException("BooleanValue", "getInt", "integer values");
    }
}

