/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.CalculationSymbol;
import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.LeafTermInherit;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import java.util.Map;

public class CalculationConstant
extends LeafTermInherit
implements CalculationSymbol {
    private CalculationSymbol.Kind _kind;
    private CalculationSymbol.Associativity _assoc;
    private int _priority;
    private String _name;

    CalculationConstant(String name, Type mytype, CalculationSymbol.Kind mykind, CalculationSymbol.Associativity assoc, int infixPriority) {
        super(mytype);
        this._name = name;
        this._kind = mykind;
        this._assoc = assoc;
        this._priority = infixPriority;
        this.setVariables(ReplaceableList.EMPTY);
    }

    @Override
    public CalculationSymbol.Kind queryKind() {
        return this._kind;
    }

    @Override
    public CalculationSymbol.Associativity queryAssociativity() {
        return this._assoc;
    }

    @Override
    public int queryInfixPriority() {
        return this._priority;
    }

    @Override
    public String queryName() {
        return this._name;
    }

    @Override
    public String toUniqueString() {
        return this._name + "{" + this.queryType().toString() + "}#calc";
    }

    @Override
    public boolean isTheorySymbol() {
        return true;
    }

    @Override
    public boolean isTheoryTerm() {
        return true;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isFunctionalTerm() {
        return true;
    }

    @Override
    public boolean isApplicative() {
        return true;
    }

    @Override
    public boolean isFirstOrder() {
        return false;
    }

    @Override
    public FunctionSymbol queryRoot() {
        return this;
    }

    @Override
    public int queryArity() {
        return this.queryType().queryArity();
    }

    @Override
    public CalculationSymbol toCalculationSymbol() {
        return this;
    }

    @Override
    public Variable queryVariable() {
        throw new InappropriatePatternDataException("CalculationConstant" + this._name, "queryVariable", "variables or lambda-expressions");
    }

    @Override
    public MetaVariable queryMetaVariable() {
        throw new InappropriatePatternDataException("CalculationConstant" + this._name, "queryMetaVariable", "meta-variable applications (or terms headed by one)");
    }

    @Override
    public CalculationSymbol renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        return this;
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        if (!term.isConstant()) {
            return false;
        }
        return this.equals(term.queryRoot());
    }

    @Override
    public boolean equals(FunctionSymbol other) {
        if (other == null) {
            return false;
        }
        if (!other.isTheorySymbol()) {
            return false;
        }
        if (!this.queryType().equals(other.queryType())) {
            return false;
        }
        return this._name.equals(other.queryName());
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        return this.queryType().hashCode() * 31 + this._name.hashCode();
    }
}

