/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.CalculationSymbol;
import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.LeafTermInherit;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import charlie.util.NullStorageException;
import java.util.Map;

class Constant
extends LeafTermInherit
implements FunctionSymbol {
    private final String _name;

    Constant(String name, Type type) {
        super(type);
        this._name = name;
        if (name == null) {
            throw new NullStorageException("Constant", "name");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Constant::constructor -- Function Symbol created with empty name.");
        }
        this.setVariables(ReplaceableList.EMPTY);
    }

    @Override
    public String queryName() {
        return this._name;
    }

    @Override
    public int queryArity() {
        return this.queryType().queryArity();
    }

    @Override
    public String toUniqueString() {
        return this._name + "{" + this.queryType().toString() + "}";
    }

    @Override
    public boolean equals(FunctionSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (!this._name.equals(symbol.queryName())) {
            return false;
        }
        if (symbol.isTheorySymbol()) {
            return false;
        }
        return this.queryType().equals(symbol.queryType());
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        return this._name.hashCode();
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isFunctionalTerm() {
        return true;
    }

    @Override
    public boolean isApplicative() {
        return true;
    }

    @Override
    public boolean isFirstOrder() {
        return this.queryType().isBaseType();
    }

    @Override
    public boolean isTheorySymbol() {
        return false;
    }

    @Override
    public boolean isTheoryTerm() {
        return false;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public CalculationSymbol toCalculationSymbol() {
        return null;
    }

    @Override
    public FunctionSymbol queryRoot() {
        return this;
    }

    @Override
    public Variable queryVariable() {
        throw new InappropriatePatternDataException("Constant", "queryVariable", "variables or lambda-expressions");
    }

    @Override
    public MetaVariable queryMetaVariable() {
        throw new InappropriatePatternDataException("Constant", "queryMetaVariable", "meta-variable applications (or terms headed by one)");
    }

    @Override
    public FunctionSymbol renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        return this;
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        if (!term.isConstant()) {
            return false;
        }
        return this.equals(term.queryRoot());
    }
}

