/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.Abstraction;
import charlie.terms.Binder;
import charlie.terms.MetaApplication;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermInherit;
import charlie.terms.replaceable.Replaceable;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.NullStorageException;
import java.util.ArrayList;

final class HigherMetaVar
implements MetaVariable {
    private static int _COUNTER = 0;
    private final String _name;
    private final FixedList<Type> _inputs;
    private final Type _output;
    private final int _index;
    private Type _mytype;

    HigherMetaVar(String name, FixedList<Type> inputs, Type output) {
        this._name = name;
        this._inputs = inputs;
        this._output = output;
        this._index = _COUNTER++;
        if (name == null) {
            throw new NullStorageException("HigherMetaVar", "name");
        }
        if (inputs == null) {
            throw new NullStorageException("HigherMetaVar", "inputs");
        }
        if (output == null) {
            throw new NullStorageException("HigherMetaVar", "output");
        }
        if (inputs.size() == 0) {
            throw new IllegalArgumentException("HigherMetaVar::constructor -- empty inputs list given: a meta-variable without arguments should be constructed as a Var instead.");
        }
        this._mytype = this._output;
        for (int i = this._inputs.size() - 1; i >= 0; --i) {
            this._mytype = TypeFactory.createArrow(this._inputs.get(i), this._mytype);
        }
    }

    @Override
    public String queryName() {
        return this._name;
    }

    @Override
    public int queryIndex() {
        return this._index;
    }

    @Override
    public int queryArity() {
        return this._inputs.size();
    }

    @Override
    public Replaceable.Kind queryReplaceableKind() {
        return Replaceable.Kind.METAVAR;
    }

    @Override
    public Type queryInputType(int i) {
        if (i <= 0 || i > this._inputs.size()) {
            throw new IndexOutOfBoundsException("HigherMetaVar::queryInputType(" + i + ") called on meta-variable with arity " + this._inputs.size() + ".");
        }
        return this._inputs.get(i - 1);
    }

    @Override
    public Type queryOutputType() {
        return this._output;
    }

    @Override
    public Type queryType() {
        return this._mytype;
    }

    public Term makeTerm() {
        ArrayList<Term> args = new ArrayList<Term>();
        for (int i = 0; i < this._inputs.size(); ++i) {
            args.add(new Binder("b" + (i + 1), this._inputs.get(i)));
        }
        TermInherit ret = new MetaApplication(this, args);
        for (int i = args.size() - 1; i >= 0; --i) {
            ret = new Abstraction(args.get(i).queryVariable(), ret);
        }
        return ret;
    }

    @Override
    public int compareTo(Replaceable other) {
        if (other == this) {
            return 0;
        }
        int d = other.queryReplaceableKind().compareTo(this.queryReplaceableKind());
        if (d != 0) {
            return d;
        }
        d = this._index - other.queryIndex();
        if (d != 0) {
            return d;
        }
        d = this._inputs.size() - other.queryArity();
        if (d != 0) {
            return d;
        }
        return this._mytype.toString().compareTo(other.queryType().toString());
    }

    @Override
    public boolean equals(Replaceable other) {
        return other == this;
    }

    public int hashCode() {
        return 3 * this._index + 2;
    }

    public String toString() {
        return this._name;
    }
}

