/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.FunctionSymbol;
import charlie.terms.InvalidPositionException;
import charlie.terms.Term;
import charlie.terms.TermInherit;
import charlie.terms.position.Position;
import charlie.types.Type;
import charlie.util.NullStorageException;
import charlie.util.Pair;
import java.util.ArrayList;
import java.util.Set;

abstract class LeafTermInherit
extends TermInherit {
    private Type _type;

    protected LeafTermInherit(Type type) {
        if (type == null) {
            throw new NullStorageException(this.queryMyClassName(), "type");
        }
        this._type = type;
    }

    @Override
    public Type queryType() {
        return this._type;
    }

    @Override
    public boolean isPattern() {
        return true;
    }

    @Override
    public boolean isSemiPattern() {
        return true;
    }

    @Override
    public void storeFunctionSymbols(Set<FunctionSymbol> storage) {
        if (this.isFunctionalTerm()) {
            storage.add(this.queryRoot());
        }
    }

    public ArrayList<Pair<Term, Position>> querySubterms() {
        ArrayList<Pair<Term, Position>> ret = new ArrayList<Pair<Term, Position>>();
        ret.add(new Pair<LeafTermInherit, Position>(this, Position.empty));
        return ret;
    }

    @Override
    public Term querySubtermMain(Position pos) {
        throw new InvalidPositionException(this, pos, "cannot query a strict subterm of a leaf term.");
    }

    @Override
    public Term replaceSubtermMain(Position pos, Term replacement) {
        throw new InvalidPositionException(this, pos, "cannot replace a strict subterm of a leaf term.");
    }
}

