/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.InvalidPositionException;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermInherit;
import charlie.terms.TypingException;
import charlie.terms.Variable;
import charlie.terms.position.MetaPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import charlie.util.NullStorageException;
import charlie.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class MetaApplication
extends TermInherit {
    public MetaVariable _metavar;
    public ArrayList<Term> _args;

    MetaApplication(MetaVariable mvar, List<Term> args) {
        if (mvar == null) {
            throw new NullStorageException("MetaApplication", "meta-variable");
        }
        if (args == null) {
            throw new NullStorageException("MetaApplication", "argument list");
        }
        this._metavar = mvar;
        if (args.size() == 0) {
            throw new IllegalArgumentException("It is not legal to create a MetaApplication with no arguments: this should be done through the Var class, since a meta-application without arguments is just a non-binder variable.");
        }
        if (args.size() != mvar.queryArity()) {
            throw new TypingException("Arity error constructing meta-variable application: meta-variable ", mvar, " has arity " + mvar.queryArity() + " but is given " + args.size() + " arguments.");
        }
        for (int i = 0; i < args.size(); ++i) {
            Term arg = args.get(i);
            if (arg == null) {
                throw new NullStorageException("MetaApplication", "passing a null argument to meta-variable application for " + mvar.queryName() + ".");
            }
            if (arg.queryType().equals(mvar.queryInputType(i + 1))) continue;
            throw new TypingException("Typing error constructing meta-variable application: imput type " + (i + 1) + " of meta-variable ", mvar, " is ", String.valueOf(mvar.queryInputType(i + 1)) + ", while the argument term ", arg, " has type ", arg.queryType());
        }
        this._args = new ArrayList();
        ReplaceableList empty = ReplaceableList.EMPTY;
        ReplaceableList start = new ReplaceableList(this._metavar);
        ReplaceableList frees = MetaApplication.calculateFreeReplaceablesForSubterms(args, start);
        ReplaceableList bounds = MetaApplication.calculateBoundVariablesAndRefreshSubs(args, empty, frees, this._args);
        this.setVariables(frees, bounds);
    }

    @Override
    public Type queryType() {
        return this._metavar.queryOutputType();
    }

    @Override
    public boolean isMetaApplication() {
        return true;
    }

    @Override
    public boolean isApplicative() {
        return false;
    }

    @Override
    public boolean isFirstOrder() {
        return false;
    }

    @Override
    public boolean isVarTerm() {
        return false;
    }

    @Override
    public boolean isTheoryTerm() {
        return false;
    }

    @Override
    public void storeFunctionSymbols(Set<FunctionSymbol> storage) {
        for (Term t : this._args) {
            t.storeFunctionSymbols(storage);
        }
    }

    @Override
    public int numberMetaArguments() {
        return this._args.size();
    }

    @Override
    public ArrayList<Term> queryMetaArguments() {
        return new ArrayList<Term>(this._args);
    }

    @Override
    public Term queryMetaArgument(int i) {
        if (i <= 0 || i > this._args.size()) {
            throw new IndexOutOfBoundsException("MetaApplication::queryMetaArgument(" + i + ") called on meta-variable application with " + this._args.size() + " arguments.");
        }
        return this._args.get(i - 1);
    }

    @Override
    public Variable queryVariable() {
        throw new InappropriatePatternDataException("MetaApplication", "queryVariable", "var terms or abstractions");
    }

    @Override
    public MetaVariable queryMetaVariable() {
        return this._metavar;
    }

    @Override
    public boolean isPattern() {
        if (this.freeReplaceables().size() != this._args.size() + 1) {
            return false;
        }
        for (int i = 0; i < this._args.size(); ++i) {
            if (!this._args.get(i).isVariable()) {
                return false;
            }
            if (this._args.get(i).queryVariable().isBinderVariable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSemiPattern() {
        return this.isPattern();
    }

    @Override
    public List<Pair<Term, Position>> querySubterms() {
        ArrayList<Pair<Term, Position>> ret = new ArrayList<Pair<Term, Position>>();
        for (int i = 0; i < this._args.size(); ++i) {
            List<Pair<Term, Position>> subs = this._args.get(i).querySubterms();
            for (int j = 0; j < subs.size(); ++j) {
                ret.add(new Pair<Term, MetaPos>(subs.get(j).fst(), new MetaPos(i + 1, subs.get(j).snd())));
            }
        }
        ret.add(new Pair<MetaApplication, Position>(this, Position.empty));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Term querySubtermMain(Position pos) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetaPos.class}, (Object)position2, n)) {
            case 0: {
                MetaPos metaPos = (MetaPos)position2;
                try {
                    Position position3;
                    int n2;
                    int index = n2 = metaPos.index();
                    Position tail = position3 = metaPos.tail();
                    if (index > this._args.size()) throw new InvalidPositionException(this, pos, "querying subterm of meta-application");
                    return this._args.get(index - 1).querySubterm(tail);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new InvalidPositionException(this, pos, "querying subterm of meta-application");
    }

    /*
     * Loose catch block
     */
    @Override
    public Term replaceSubtermMain(Position pos, Term replacement) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetaPos.class}, (Object)position2, n)) {
            case 0: {
                Position position3;
                int n2;
                MetaPos metaPos = (MetaPos)position2;
                int index = n2 = metaPos.index();
                Position tail = position3 = metaPos.tail();
                if (index > this._args.size()) break;
                Term tmp = this._args.get(index - 1);
                this._args.set(index - 1, tmp.replaceSubterm(tail, replacement));
                MetaApplication ret = new MetaApplication(this._metavar, this._args);
                this._args.set(index - 1, tmp);
                return ret;
            }
        }
        throw new InvalidPositionException(this, pos, "replacing subterm of meta-application");
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    public Term renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        ArrayList<Term> args = new ArrayList<Term>(this._args);
        boolean changed = false;
        for (int i = 0; i < args.size(); ++i) {
            Term other = args.get(i).renameAndRefreshBinders(renaming);
            if (other == args.get(i)) continue;
            changed = true;
            args.set(i, other);
        }
        if (!changed) {
            return this;
        }
        return new MetaApplication(this._metavar, args);
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        if (!term.isMetaApplication()) {
            return false;
        }
        if (!this._metavar.equals(term.queryMetaVariable())) {
            return false;
        }
        for (int i = 0; i < this._args.size(); ++i) {
            if (this._args.get(i).alphaEquals(term.queryMetaArgument(i + 1), mu, xi, k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        int ret = this._metavar.hashCode();
        for (int i = 0; i < this._args.size(); ++i) {
            ret = 31 * ret + this._args.get(i).hashCode(mu);
        }
        return ret;
    }
}

