/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.IncorrectStringException;
import charlie.terms.ValueInherit;
import charlie.terms.Variable;
import charlie.types.TypeFactory;
import java.util.Map;

class StringValue
extends ValueInherit {
    private final String _value;
    private final String _escapedValue;

    private static String makePrintable(String str) {
        return "\"" + str.replace("\\", "\\\\").replace("\n", "\\n").replace("\"", "\\\"") + "\"";
    }

    StringValue(String str) {
        super(TypeFactory.stringSort);
        this._value = str;
        this._escapedValue = StringValue.makePrintable(str);
    }

    private StringValue(String str, String escaped) {
        super(TypeFactory.stringSort);
        this._value = str;
        this._escapedValue = escaped;
    }

    static StringValue parseUserStringValue(String str) throws IncorrectStringException {
        if (str.length() < 2 || str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '\"') {
            throw new IncorrectStringException(str, "string should have double quotes on either side");
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 1; i < str.length() - 1; ++i) {
            if (str.charAt(i) != '\\') {
                ret.append(str.substring(i, i + 1));
                continue;
            }
            if (str.charAt(i + 1) == 'n') {
                ret.append("\n");
            } else if (str.charAt(i + 1) == '\\') {
                ret.append("\\");
            } else if (str.charAt(i + 1) == '\"') {
                ret.append("\"");
            } else {
                throw new IncorrectStringException(str, "stray escape character at position " + (i + 1) + ": " + str.substring(i, i + 2) + " is not an escape sequence.");
            }
            ++i;
        }
        return new StringValue(ret.toString(), str);
    }

    @Override
    public String queryName() {
        return this._escapedValue;
    }

    @Override
    public String toUniqueString() {
        return this._escapedValue;
    }

    @Override
    public boolean equals(FunctionSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (!symbol.isValue()) {
            return false;
        }
        if (!symbol.queryType().equals(TypeFactory.stringSort)) {
            return false;
        }
        return symbol.toValue().queryName().equals(this._escapedValue);
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        return this._value.hashCode();
    }

    @Override
    public int getInt() {
        throw new InappropriatePatternDataException("StringValue", "getInt", "integer values");
    }

    @Override
    public String getString() {
        return this._value;
    }

    @Override
    public boolean getBool() {
        throw new InappropriatePatternDataException("StringValue", "getBool", "boolean values");
    }
}

