/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.Environment;
import charlie.terms.FunctionSymbol;
import charlie.terms.MetaVariable;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.terms.position.Position;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import charlie.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public interface Term {
    public Type queryType();

    public boolean isVariable();

    public boolean isConstant();

    public boolean isFunctionalTerm();

    public boolean isVarTerm();

    public boolean isApplication();

    public boolean isAbstraction();

    public boolean isMetaApplication();

    public boolean isTuple();

    public boolean isBetaRedex();

    public boolean isGround();

    public boolean isClosed();

    public boolean isTrueTerm();

    public boolean isTheoryTerm();

    public boolean isValue();

    public boolean isLinear();

    public int numberArguments();

    public int numberMetaArguments();

    public int numberTupleArguments();

    public ArrayList<Term> queryArguments();

    public ArrayList<Term> queryTupleArguments();

    public ArrayList<Term> queryMetaArguments();

    public Term queryArgument(int var1);

    public Term queryMetaArgument(int var1);

    public Term queryTupleArgument(int var1);

    public Term queryAbstractionSubterm();

    public Term queryImmediateHeadSubterm(int var1);

    public Term queryHead();

    public FunctionSymbol queryRoot();

    public Variable queryVariable();

    public MetaVariable queryMetaVariable();

    public Value toValue();

    public boolean isFirstOrder();

    public boolean isPattern();

    public boolean isSemiPattern();

    public boolean isApplicative();

    public boolean hasSubterm(Term var1);

    public List<Pair<Term, Position>> querySubterms();

    public List<Position> queryPositions(boolean var1);

    public void visitSubterms(BiConsumer<Term, Position> var1);

    public Pair<Term, Position> findSubterm(BiFunction<Term, Position, Boolean> var1);

    public Environment<Variable> vars();

    public Environment<MetaVariable> mvars();

    public ReplaceableList freeReplaceables();

    public void storeFunctionSymbols(Set<FunctionSymbol> var1);

    public Term querySubterm(Position var1);

    public Term replaceSubterm(Position var1, Term var2);

    public Term apply(List<Term> var1);

    public Term apply(Term var1);

    public String toString();

    public boolean equals(Term var1);

    public Term renameAndRefreshBinders(Map<Variable, Variable> var1);

    public ReplaceableList boundVars();

    public boolean alphaEquals(Term var1, Map<Variable, Integer> var2, Map<Variable, Integer> var3, int var4);

    public int hashCode(Map<Variable, Integer> var1);
}

