/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.Abstraction;
import charlie.terms.Application;
import charlie.terms.Binder;
import charlie.terms.Constant;
import charlie.terms.FunctionSymbol;
import charlie.terms.HigherMetaVar;
import charlie.terms.MetaApplication;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermInherit;
import charlie.terms.Tuple;
import charlie.terms.TypingException;
import charlie.terms.Var;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.types.Arrow;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TermFactory {
    public static Variable createVar(String name, Type type) {
        return new Var(name, type);
    }

    public static Variable createVar(String name) {
        return new Var(name, TypeFactory.defaultSort);
    }

    public static Variable createVar(Type type) {
        return new Var(type);
    }

    public static Variable createVar() {
        return new Var(TypeFactory.defaultSort);
    }

    public static Variable createBinder(String name, Type type) {
        return new Binder(name, type);
    }

    public static FunctionSymbol createConstant(String name, Type type) {
        return new Constant(name, type);
    }

    public static FunctionSymbol createConstant(String name, int arity) {
        Type type = TypeFactory.defaultSort;
        for (int i = 0; i < arity; ++i) {
            type = TypeFactory.createArrow(TypeFactory.defaultSort, type);
        }
        return new Constant(name, type);
    }

    public static Term createFunctionalTerm(FunctionSymbol f, List<Term> args) {
        if (args == null || args.size() == 0) {
            return f;
        }
        return new Application((Term)f, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MetaVariable createMetaVar(String name, Type type, int arity) {
        if (arity == 0) {
            return new Var(name, type);
        }
        if (arity < 0) {
            throw new IllegalArgumentException("TermFactory::createMetaVar received negative arity " + arity + ".");
        }
        FixedList.Builder<Type> builder = new FixedList.Builder<Type>();
        Type tmp = type;
        int i = 0;
        block5: while (true) {
            Type type2;
            if (i >= arity) {
                return new HigherMetaVar(name, builder.build(), tmp);
            }
            Objects.requireNonNull(tmp);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class}, (Object)type2, n)) {
                case 0: {
                    Arrow arrow = (Arrow)type2;
                    try {
                        Type type3;
                        Type inp = type3 = arrow.left();
                        Type out = type3 = arrow.right();
                        builder.add(inp);
                        tmp = out;
                        ++i;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                continue block5;
            }
            break;
        }
        throw new TypingException("Cannot construct meta-variable with type ", type, " and arity " + arity + " since the arity may not be larger than the number of input arguments to the type.");
    }

    public static MetaVariable createMetaVar(String name, FixedList<Type> inputs, Type output) {
        if (inputs.size() == 0) {
            return new Var(name, output);
        }
        return new HigherMetaVar(name, inputs, output);
    }

    public static MetaVariable createMetaVar(String name, List<Type> inputs, Type output) {
        if (inputs.size() == 0) {
            return new Var(name, output);
        }
        return new HigherMetaVar(name, FixedList.copy(inputs), output);
    }

    public static MetaVariable createMetaVar(String name, Type input, Type output) {
        return new HigherMetaVar(name, FixedList.of(input), output);
    }

    public static MetaVariable createMetaVar(String name, Type in1, Type in2, Type output) {
        return new HigherMetaVar(name, FixedList.of(in1, in2), output);
    }

    public static Term createTuple(Term a, Term b) {
        return new Tuple(a, b);
    }

    public static Term createTuple(Term a, Term b, Term c) {
        return new Tuple(a, b, c);
    }

    public static Term createTuple(List<Term> elems) {
        return new Tuple(elems);
    }

    public static Term createApp(Term head, Term arg) {
        return head.apply(arg);
    }

    public static Term createApp(Term head, Term arg1, Term arg2) {
        return head.apply(List.of(arg1, arg2));
    }

    public static Term createApp(Term head, List<Term> args) {
        if (args.size() == 0) {
            return head;
        }
        return head.apply(args);
    }

    public static Term createAbstraction(Variable binder, Term subterm) {
        return new Abstraction(binder, subterm);
    }

    public static Term createMeta(MetaVariable mv, List<Term> args) {
        if (args != null && args.size() == 0 && mv instanceof Var) {
            return (Var)mv;
        }
        return new MetaApplication(mv, args);
    }

    public static Term createMeta(MetaVariable mv, Term arg) {
        return new MetaApplication(mv, List.of(arg));
    }

    public static Term createMeta(MetaVariable mv, Term arg1, Term arg2) {
        return new MetaApplication(mv, List.of(arg1, arg2));
    }

    public static Term makeTerm(Replaceable x) {
        if (x instanceof Term) {
            Term s = (Term)((Object)x);
            return s;
        }
        if (x instanceof HigherMetaVar) {
            HigherMetaVar z = (HigherMetaVar)x;
            ArrayList<Term> args = new ArrayList<Term>();
            for (int i = 1; i <= z.queryArity(); ++i) {
                args.add(new Binder("b" + i, z.queryInputType(i)));
            }
            TermInherit ret = new MetaApplication(z, args);
            for (int i = args.size() - 1; i >= 0; --i) {
                ret = new Abstraction(args.get(i).queryVariable(), ret);
            }
            return ret;
        }
        throw new IllegalArgumentException("Given replaceable " + x.queryName() + " which is neither a term nor a higher meta-variable!");
    }
}

