/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.Application;
import charlie.terms.Environment;
import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.MetaVariable;
import charlie.terms.MetaVariableEnvironment;
import charlie.terms.Term;
import charlie.terms.TermPrinter;
import charlie.terms.TypingException;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.terms.VariableEnvironment;
import charlie.terms.position.FinalPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.Replaceable;
import charlie.terms.replaceable.ReplaceableList;
import charlie.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

abstract class TermInherit
implements Term {
    private ReplaceableList _freeReplaceables;
    private ReplaceableList _boundVariables;

    TermInherit() {
    }

    protected final void setVariables(ReplaceableList vs) {
        if (this._freeReplaceables != null) {
            throw new RuntimeException("Setting ReplaceableList twice for " + this.getClass().getSimpleName());
        }
        this._freeReplaceables = vs;
        this._boundVariables = ReplaceableList.EMPTY;
    }

    protected final void setVariables(ReplaceableList frees, ReplaceableList bounds) {
        if (this._freeReplaceables != null) {
            throw new RuntimeException("Setting ReplaceableList twice for " + this.getClass().getSimpleName());
        }
        this._freeReplaceables = frees;
        this._boundVariables = bounds == null ? ReplaceableList.EMPTY : bounds;
    }

    protected static ReplaceableList calculateFreeReplaceablesForSubterms(List<Term> subs, ReplaceableList extra) {
        ReplaceableList largest = extra;
        int best = 0;
        for (int i = 0; i < subs.size(); ++i) {
            if (subs.get(i).freeReplaceables().size() <= largest.size()) continue;
            best = i + 1;
            largest = subs.get(i).freeReplaceables();
        }
        ReplaceableList frees = largest;
        if (best != 0) {
            frees = frees.combine(extra);
        }
        for (int i = 0; i < subs.size(); ++i) {
            if (best == i + 1) continue;
            frees = frees.combine(subs.get(i).freeReplaceables());
        }
        return frees;
    }

    protected static ReplaceableList calculateBoundVariablesAndRefreshSubs(List<Term> subs, ReplaceableList include, ReplaceableList avoid, List<Term> updatedSubs) {
        for (int i = 0; i < subs.size(); ++i) {
            Term sub = subs.get(i);
            ReplaceableList vs = sub.boundVars();
            if (vs.size() > 0) {
                if (!vs.getOverlap(avoid).isEmpty()) {
                    sub = sub.renameAndRefreshBinders(new TreeMap<Variable, Variable>());
                    vs = sub.boundVars();
                }
                include = include.size() == 0 ? vs : include.combine(vs);
            }
            updatedSubs.add(sub);
        }
        return include;
    }

    @Override
    public final Environment<Variable> vars() {
        if (this._freeReplaceables == null) {
            throw new RuntimeException("Variable list requested when it has not been set up for " + this.getClass().getSimpleName());
        }
        return new VariableEnvironment(this._freeReplaceables);
    }

    @Override
    public final Environment<MetaVariable> mvars() {
        if (this._freeReplaceables == null) {
            throw new RuntimeException("Meta-variable list requested when it has not been set up for " + this.getClass().getSimpleName());
        }
        return new MetaVariableEnvironment(this._freeReplaceables);
    }

    @Override
    public final ReplaceableList freeReplaceables() {
        if (this._freeReplaceables == null) {
            throw new RuntimeException("Replaceable list has not been set up for " + this.getClass().getSimpleName() + " when requesting free replaceables.");
        }
        return this._freeReplaceables;
    }

    @Override
    public final ReplaceableList boundVars() {
        if (this._freeReplaceables == null) {
            throw new RuntimeException("Replaceable list has not been set up for " + this.getClass().getSimpleName() + " when requesting bound variables");
        }
        return this._boundVariables;
    }

    @Override
    public final boolean isGround() {
        return this._freeReplaceables.size() == 0;
    }

    @Override
    public boolean isClosed() {
        ReplaceableList vs = this.freeReplaceables();
        for (Replaceable x : vs) {
            if (x.queryReplaceableKind() != Replaceable.Kind.BINDER) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isLinear() {
        TreeSet<MetaVariable> mvars = new TreeSet<MetaVariable>();
        for (Pair<Term, Position> p : this.querySubterms()) {
            if (!p.fst().isMetaApplication()) continue;
            MetaVariable x = p.fst().queryMetaVariable();
            if (mvars.contains(x)) {
                return false;
            }
            mvars.add(x);
        }
        return true;
    }

    @Override
    public boolean isTrueTerm() {
        ReplaceableList vs = this.freeReplaceables();
        for (Replaceable x : vs) {
            if (x.queryReplaceableKind() != Replaceable.Kind.METAVAR) continue;
            return false;
        }
        return true;
    }

    protected final String queryMyClassName() {
        return this.getClass().getSimpleName();
    }

    public final ArrayList<Position> queryPositions(boolean partial) {
        List<Pair<Term, Position>> subs = this.querySubterms();
        ArrayList<Position> ret = new ArrayList<Position>();
        for (Pair<Term, Position> pair : subs) {
            Position p = pair.snd();
            if (partial) {
                for (int j = pair.fst().numberArguments(); j > 0; --j) {
                    ret.add(p.append(new FinalPos(j)));
                }
            }
            ret.add(p);
        }
        return ret;
    }

    @Override
    public boolean hasSubterm(Term other) {
        for (Pair<Term, Position> p : this.querySubterms()) {
            if (!p.fst().equals(other)) continue;
            for (Replaceable x : other.freeReplaceables()) {
                if (x.queryReplaceableKind() != Replaceable.Kind.BINDER || this._freeReplaceables.contains(x)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract Term querySubtermMain(Position var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Term querySubterm(Position pos) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FinalPos.class}, (Object)position2, n)) {
            case 0: {
                FinalPos finalPos = (FinalPos)position2;
                try {
                    int n2;
                    int k = n2 = finalPos.chopcount();
                    if (k != 0) return this.querySubtermMain(pos);
                    return this;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return this.querySubtermMain(pos);
    }

    protected abstract Term replaceSubtermMain(Position var1, Term var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Term replaceSubterm(Position pos, Term replacement) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FinalPos.class}, (Object)position2, n)) {
            case 0: {
                FinalPos finalPos = (FinalPos)position2;
                try {
                    int n2;
                    int k = n2 = finalPos.chopcount();
                    if (k != 0) return this.replaceSubtermMain(pos, replacement);
                    if (this.queryType().equals(replacement.queryType())) return replacement;
                    throw new TypingException("Typing error: cannot replace ", this, " (of type ", this.queryType(), ") by ", replacement, " (of type ", replacement.queryType(), ").");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return this.replaceSubtermMain(pos, replacement);
    }

    @Override
    public final void visitSubterms(BiConsumer<Term, Position> vis) {
        for (Pair<Term, Position> p : this.querySubterms()) {
            vis.accept(p.fst(), p.snd());
        }
    }

    @Override
    public final Pair<Term, Position> findSubterm(BiFunction<Term, Position, Boolean> vis) {
        for (Pair<Term, Position> p : this.querySubterms()) {
            if (!vis.apply(p.fst(), p.snd()).booleanValue()) continue;
            return p;
        }
        return null;
    }

    @Override
    public final Term apply(Term other) {
        ArrayList<Term> args = new ArrayList<Term>();
        args.add(other);
        return this.apply(args);
    }

    @Override
    public Term apply(List<Term> args) {
        if (args.size() == 0) {
            return this;
        }
        return new Application((Term)this, args);
    }

    @Override
    public boolean equals(Term other) {
        if (other == null) {
            return false;
        }
        TreeMap<Variable, Integer> mu = new TreeMap<Variable, Integer>();
        TreeMap<Variable, Integer> xi = new TreeMap<Variable, Integer>();
        return this.alphaEquals(other, mu, xi, 1);
    }

    public final boolean equals(Object other) {
        if (other instanceof Term) {
            return this.equals((Term)other);
        }
        return false;
    }

    public final int hashCode() {
        return this.hashCode(null);
    }

    @Override
    public final String toString() {
        return new TermPrinter(Set.of()).print(this);
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isFunctionalTerm() {
        return false;
    }

    @Override
    public boolean isVarTerm() {
        return false;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isAbstraction() {
        return false;
    }

    @Override
    public boolean isMetaApplication() {
        return false;
    }

    @Override
    public boolean isTuple() {
        return false;
    }

    @Override
    public boolean isBetaRedex() {
        return false;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public Value toValue() {
        return null;
    }

    @Override
    public int numberArguments() {
        return 0;
    }

    @Override
    public int numberMetaArguments() {
        return 0;
    }

    @Override
    public int numberTupleArguments() {
        return 0;
    }

    @Override
    public ArrayList<Term> queryArguments() {
        return new ArrayList<Term>();
    }

    @Override
    public ArrayList<Term> queryTupleArguments() {
        return new ArrayList<Term>();
    }

    @Override
    public ArrayList<Term> queryMetaArguments() {
        return new ArrayList<Term>();
    }

    @Override
    public Term queryHead() {
        return this;
    }

    @Override
    public Term queryArgument(int i) {
        throw new IndexOutOfBoundsException(this.queryMyClassName() + "::queryArgument(" + i + ") called.");
    }

    @Override
    public Term queryMetaArgument(int i) {
        throw new IndexOutOfBoundsException(this.queryMyClassName() + "::queryMetaArgument(" + i + ") called.");
    }

    @Override
    public Term queryTupleArgument(int i) {
        throw new IndexOutOfBoundsException(this.queryMyClassName() + "::queryTupleArgument(" + i + ") called.");
    }

    @Override
    public Term queryImmediateHeadSubterm(int i) {
        if (i == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException(this.queryMyClassName() + "::queryImmediateHeadSubterm(" + i + ") called.");
    }

    @Override
    public Term queryAbstractionSubterm() {
        throw new InappropriatePatternDataException(this.queryMyClassName(), "queryAbstractionSubterm", "abstractions");
    }

    @Override
    public FunctionSymbol queryRoot() {
        throw new InappropriatePatternDataException(this.queryMyClassName(), "queryRoot", "functional terms");
    }
}

