/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.CalculationSymbol;
import charlie.terms.FunctionSymbol;
import charlie.terms.IntegerValue;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.types.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;

public class TermPrinter {
    private TreeSet<String> _blockedNames;

    public TermPrinter(Set<String> avoid) {
        this._blockedNames = new TreeSet<String>(avoid);
    }

    public final void avoidAdditional(String name) {
        this._blockedNames.add(name);
    }

    public final void avoidAdditional(Set<String> names) {
        this._blockedNames.addAll(names);
    }

    public final MutableRenaming generateUniqueNaming(Term ... terms) {
        return this.generateUniqueNaming(Arrays.asList(terms));
    }

    public final MutableRenaming generateUniqueNaming(List<Term> terms) {
        TreeMap existingNames = new TreeMap();
        for (Term t : terms) {
            for (Replaceable x : t.freeReplaceables()) {
                String name = x.queryName();
                if (!existingNames.containsKey(name)) {
                    TreeSet<Replaceable> tmp = new TreeSet<Replaceable>();
                    tmp.add(x);
                    existingNames.put(name, tmp);
                    continue;
                }
                ((TreeSet)existingNames.get(name)).add(x);
            }
        }
        MutableRenaming ret = new MutableRenaming(this._blockedNames);
        for (int i = 0; i < 2; ++i) {
            for (TreeSet set : existingNames.values()) {
                if (i == 0 && set.size() != 1 || i == 1 && set.size() == 1) continue;
                int counter = 0;
                for (Replaceable x : set) {
                    String name = this.generateName(x, n -> ret.isAvailable((String)n), ++counter, set.size());
                    ret.setName(x, name);
                    if (name.equals(x.queryName())) continue;
                    ret.avoid(x.queryName());
                }
            }
        }
        return ret;
    }

    protected String generateName(Replaceable x, Predicate<String> available, int count, int num) {
        Object base = x.queryName();
        if (((String)base).equals("")) {
            base = "VAR";
        } else if (!this.isGoodNameStart(((String)base).charAt(0))) {
            base = "_" + (String)base;
        }
        if (num == 1 && available.test((String)base)) {
            return base;
        }
        String name = (String)base + "__" + count;
        if (available.test(name)) {
            return name;
        }
        count = num;
        while (!available.test(name = (String)base + "__" + ++count)) {
        }
        return name;
    }

    private boolean isGoodNameStart(char c) {
        if (c == '#' || c == '$' || c == '?') {
            return true;
        }
        return c >= 'A' && c != '[' && c != ']';
    }

    public final String print(Term term) {
        StringBuilder builder = new StringBuilder();
        this.print(term, builder);
        return builder.toString();
    }

    public final String print(Term term, Renaming naming) {
        StringBuilder builder = new StringBuilder();
        this.print(term, naming, builder);
        return builder.toString();
    }

    public final void print(Term term, StringBuilder builder) {
        this.print(term, this.generateUniqueNaming(term), builder);
    }

    public final void print(Term term, Renaming naming, StringBuilder builder) {
        TreeSet<String> blocked = new TreeSet<String>((SortedSet<String>)this._blockedNames);
        blocked.addAll(naming.range());
        for (Replaceable x : naming.domain()) {
            blocked.add(x.queryName());
        }
        MutableRenaming mren = new MutableRenaming(blocked);
        this.printRecursive(term, naming, mren, builder);
    }

    protected final void printRecursive(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        if (term.isVariable()) {
            this.printVariable(term.queryVariable(), freeNaming, boundNaming, builder);
        } else if (term.isVarTerm()) {
            this.printVarTerm(term, freeNaming, boundNaming, builder);
        } else if (term.isValue()) {
            this.printValue(term.toValue(), builder);
        } else if (term.isConstant()) {
            FunctionSymbol root = term.queryRoot();
            if (root.isTheorySymbol()) {
                this.printSoloCalculationSymbol(root.toCalculationSymbol(), builder);
            } else {
                this.printConstant(root, builder);
            }
        } else if (term.isFunctionalTerm()) {
            FunctionSymbol root = term.queryRoot();
            if (!root.isTheorySymbol()) {
                this.printFunctionalTerm(term, freeNaming, boundNaming, builder);
            } else if (term.queryType().isArrowType()) {
                this.printPartialTheoryTerm(term, freeNaming, boundNaming, builder);
            } else {
                this.printFullTheoryTerm(term, freeNaming, boundNaming, builder);
            }
        } else if (term.isTuple()) {
            this.printTuple(term, freeNaming, boundNaming, builder);
        } else if (term.isAbstraction()) {
            this.printAbstraction(term, freeNaming, boundNaming, builder);
        } else if (term.isMetaApplication()) {
            this.printMetaApplication(term, freeNaming, boundNaming, builder);
        } else if (term.isApplication()) {
            this.printApplication(term, freeNaming, boundNaming, builder);
        } else {
            throw new IllegalArgumentException("TermPrinter::print called with a term that does not have any of the standard term shapes!");
        }
    }

    protected void printVariable(Variable variable, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        String name = boundNaming.getName(variable);
        if (name == null) {
            name = freeNaming.getName(variable);
        }
        if (name == null) {
            builder.append(variable.queryName());
        } else {
            builder.append(name);
        }
    }

    public void printReplaceable(Replaceable r, Renaming naming, StringBuilder builder) {
        String name = naming.getName(r);
        if (name == null) {
            builder.append(r.queryName());
        } else {
            builder.append(name);
        }
    }

    protected void printConstant(FunctionSymbol constant, StringBuilder builder) {
        builder.append(constant.queryName());
    }

    protected void printValue(Value value, StringBuilder builder) {
        builder.append(value.queryName());
    }

    protected void printSoloCalculationSymbol(CalculationSymbol constant, StringBuilder builder) {
        builder.append("[");
        builder.append(this.queryCalculationName(constant.queryKind(), constant.queryName(), constant.queryType()));
        builder.append("]");
    }

    protected void printVarTerm(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        this.printApplication(term, freeNaming, boundNaming, builder);
    }

    protected void printFunctionalTerm(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        this.printApplication(term, freeNaming, boundNaming, builder);
    }

    protected void printPartialTheoryTerm(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        this.printApplication(term, freeNaming, boundNaming, builder);
    }

    protected void printFullTheoryTerm(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        CalculationSymbol root = term.queryRoot().toCalculationSymbol();
        if (term.numberArguments() == 0) {
            this.printSoloCalculationSymbol(root, builder);
        } else if (term.numberArguments() == 1) {
            this.printUnaryCalculation(root, term.queryArgument(1), freeNaming, boundNaming, builder);
        } else if (term.numberArguments() == 2 && root.queryAssociativity() != CalculationSymbol.Associativity.NOT_INFIX) {
            this.printInfix(root, term.queryArgument(1), term.queryArgument(2), freeNaming, boundNaming, builder);
        } else {
            this.printApplication(term, freeNaming, boundNaming, builder);
        }
    }

    protected void printUnaryCalculation(CalculationSymbol rootsymb, Term arg, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        Value v;
        boolean brackets;
        boolean bl = brackets = arg.isFunctionalTerm() && arg.queryRoot().toCalculationSymbol() != null;
        if (!brackets && arg.isValue() && (v = arg.toValue()).isIntegerValue() && v.getInt() < 0) {
            brackets = true;
        }
        builder.append(this.queryCalculationName(rootsymb.queryKind(), rootsymb.queryName(), rootsymb.queryType()));
        if (brackets) {
            builder.append("(");
        }
        this.printRecursive(arg, freeNaming, boundNaming, builder);
        if (brackets) {
            builder.append(")");
        }
    }

    protected void printInfix(CalculationSymbol root, Term left, Term right, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        CalculationSymbol.Kind rootkind = root.queryKind();
        String rootname = root.queryName();
        if (root.queryKind().equals((Object)CalculationSymbol.Kind.PLUS)) {
            if (right.isFunctionalTerm() && right.queryRoot().toCalculationSymbol() != null && right.queryRoot().toCalculationSymbol().queryKind().equals((Object)CalculationSymbol.Kind.MINUS)) {
                rootkind = CalculationSymbol.Kind.MINUS;
                rootname = "-";
                right = right.queryArgument(1);
            } else if (right.isValue() && right.toValue().getInt() < 0) {
                rootkind = CalculationSymbol.Kind.MINUS;
                rootname = "-";
                right = new IntegerValue(-right.toValue().getInt());
            }
        }
        int leftpriority = root.queryInfixPriority();
        int rightpriority = root.queryInfixPriority();
        if (root.queryAssociativity().equals((Object)CalculationSymbol.Associativity.ASSOC_LEFT) && left.isFunctionalTerm() && left.queryRoot().equals(root)) {
            --leftpriority;
        }
        if (root.queryAssociativity().equals((Object)CalculationSymbol.Associativity.ASSOC_RIGHT) && right.isFunctionalTerm() && right.queryRoot().equals(root)) {
            --rightpriority;
        }
        this.printInfixHelper(left, freeNaming, boundNaming, builder, leftpriority);
        this.printInfixOperator(rootkind, rootname, root.queryType(), builder);
        this.printInfixHelper(right, freeNaming, boundNaming, builder, rightpriority);
    }

    protected void printInfixOperator(CalculationSymbol.Kind operatorkind, String operatorname, Type operatortype, StringBuilder builder) {
        builder.append(" ");
        builder.append(this.queryCalculationName(operatorkind, operatorname, operatortype));
        builder.append(" ");
    }

    private void printInfixHelper(Term arg, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder, int priority) {
        CalculationSymbol root;
        boolean brackets = false;
        if (arg.isFunctionalTerm() && (root = arg.queryRoot().toCalculationSymbol()) != null && root.queryInfixPriority() > 0) {
            boolean bl = brackets = root.queryInfixPriority() <= priority;
        }
        if (brackets) {
            builder.append("(");
        }
        this.printRecursive(arg, freeNaming, boundNaming, builder);
        if (brackets) {
            builder.append(")");
        }
    }

    protected void printTuple(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        builder.append(this.queryTupleOpenBracket());
        for (int i = 1; i <= term.numberTupleArguments(); ++i) {
            if (i > 1) {
                builder.append(", ");
            }
            this.printRecursive(term.queryTupleArgument(i), freeNaming, boundNaming, builder);
        }
        builder.append(this.queryTupleCloseBracket());
    }

    protected void printAbstraction(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        Variable binder = term.queryVariable();
        String backup = boundNaming.getName(binder);
        String bname = binder.queryName();
        Object name = bname;
        int i = 1;
        while (!boundNaming.isAvailable((String)name)) {
            name = bname + i;
            ++i;
        }
        boundNaming.setName(binder, (String)name);
        builder.append(this.queryLambda());
        this.printAbstractionBinder(binder, (String)name, builder);
        builder.append(".");
        this.printRecursive(term.queryAbstractionSubterm(), freeNaming, boundNaming, builder);
        if (backup == null) {
            boundNaming.unsetName(binder);
        } else {
            boundNaming.setName(binder, backup);
        }
    }

    protected void printAbstractionBinder(Variable binder, String chosenName, StringBuilder builder) {
        builder.append(chosenName);
    }

    protected void printMetaApplication(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        MetaVariable mvar = term.queryMetaVariable();
        String name = freeNaming.getName(mvar);
        if (name == null) {
            builder.append(mvar.queryName());
        } else {
            builder.append(name);
        }
        builder.append(this.queryMetaOpenBracket());
        for (int i = 1; i <= term.numberMetaArguments(); ++i) {
            if (i != 1) {
                builder.append(", ");
            }
            this.printRecursive(term.queryMetaArgument(i), freeNaming, boundNaming, builder);
        }
        builder.append(this.queryMetaCloseBracket());
    }

    protected void printApplication(Term term, Renaming freeNaming, MutableRenaming boundNaming, StringBuilder builder) {
        Term head = term.queryHead();
        if (head.isAbstraction()) {
            builder.append("(");
        }
        this.printRecursive(head, freeNaming, boundNaming, builder);
        if (head.isAbstraction()) {
            builder.append(")");
        }
        builder.append("(");
        for (int i = 1; i <= term.numberArguments(); ++i) {
            if (i > 1) {
                builder.append(", ");
            }
            this.printRecursive(term.queryArgument(i), freeNaming, boundNaming, builder);
        }
        builder.append(")");
    }

    protected String queryTupleOpenBracket() {
        return "\u2987";
    }

    protected String queryTupleCloseBracket() {
        return "\u2988";
    }

    protected String queryLambda() {
        return "\u03bb";
    }

    protected String queryMetaOpenBracket() {
        return "\u27e8";
    }

    protected String queryMetaCloseBracket() {
        return "\u27e9";
    }

    protected String queryCalculationName(CalculationSymbol.Kind kind, String defaultName, Type operatorType) {
        return defaultName;
    }
}

