/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.Application;
import charlie.terms.BooleanValue;
import charlie.terms.CalculationConstant;
import charlie.terms.CalculationSymbol;
import charlie.terms.IncorrectStringException;
import charlie.terms.IntegerValue;
import charlie.terms.StringValue;
import charlie.terms.Term;
import charlie.terms.Value;
import charlie.terms.Var;
import charlie.terms.Variable;
import charlie.types.Base;
import charlie.types.Type;
import charlie.types.TypeFactory;
import java.util.LinkedHashSet;
import java.util.Set;

public class TheoryFactory {
    private static Type binaryIntOperatorType = TypeFactory.createArrow(TypeFactory.intSort, TypeFactory.createArrow(TypeFactory.intSort, TypeFactory.intSort));
    private static Type binaryIntComparisonType = TypeFactory.createArrow(TypeFactory.intSort, TypeFactory.createArrow(TypeFactory.intSort, TypeFactory.boolSort));
    private static Type binaryStringComparisonType = TypeFactory.createArrow(TypeFactory.stringSort, TypeFactory.createArrow(TypeFactory.stringSort, TypeFactory.boolSort));
    private static Type binaryBoolConnectiveType = TypeFactory.createArrow(TypeFactory.boolSort, TypeFactory.createArrow(TypeFactory.boolSort, TypeFactory.boolSort));
    public static final CalculationSymbol plusSymbol = new CalculationConstant("+", binaryIntOperatorType, CalculationSymbol.Kind.PLUS, CalculationSymbol.Associativity.ASSOC_LEFT, 4);
    public static final CalculationSymbol timesSymbol = new CalculationConstant("*", binaryIntOperatorType, CalculationSymbol.Kind.TIMES, CalculationSymbol.Associativity.ASSOC_LEFT, 5);
    public static final CalculationSymbol minusSymbol = new CalculationConstant("-", TypeFactory.createArrow(TypeFactory.intSort, TypeFactory.intSort), CalculationSymbol.Kind.MINUS, CalculationSymbol.Associativity.NOT_INFIX, 0);
    public static final CalculationSymbol divSymbol = new CalculationConstant("/", binaryIntOperatorType, CalculationSymbol.Kind.DIV, CalculationSymbol.Associativity.ASSOC_NONE, 5);
    public static final CalculationSymbol modSymbol = new CalculationConstant("%", binaryIntOperatorType, CalculationSymbol.Kind.MOD, CalculationSymbol.Associativity.ASSOC_NONE, 5);
    public static final CalculationSymbol andSymbol = new CalculationConstant("\u2227", binaryBoolConnectiveType, CalculationSymbol.Kind.AND, CalculationSymbol.Associativity.ASSOC_LEFT, 2);
    public static final CalculationSymbol orSymbol = new CalculationConstant("\u2228", binaryBoolConnectiveType, CalculationSymbol.Kind.OR, CalculationSymbol.Associativity.ASSOC_LEFT, 2);
    public static final CalculationSymbol notSymbol = new CalculationConstant("\u00ac", TypeFactory.createArrow(TypeFactory.boolSort, TypeFactory.boolSort), CalculationSymbol.Kind.NOT, CalculationSymbol.Associativity.NOT_INFIX, 0);
    public static final CalculationSymbol iffSymbol = new CalculationConstant("\u21d4", binaryBoolConnectiveType, CalculationSymbol.Kind.IFF, CalculationSymbol.Associativity.ASSOC_NONE, 1);
    public static final CalculationSymbol xorSymbol = new CalculationConstant("\u22bb", binaryBoolConnectiveType, CalculationSymbol.Kind.XOR, CalculationSymbol.Associativity.ASSOC_NONE, 1);
    public static final CalculationSymbol greaterSymbol = new CalculationConstant(">", binaryIntComparisonType, CalculationSymbol.Kind.GREATER, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final CalculationSymbol smallerSymbol = new CalculationConstant("<", binaryIntComparisonType, CalculationSymbol.Kind.SMALLER, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final CalculationSymbol geqSymbol = new CalculationConstant("\u2265", binaryIntComparisonType, CalculationSymbol.Kind.GEQ, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final CalculationSymbol leqSymbol = new CalculationConstant("\u2264", binaryIntComparisonType, CalculationSymbol.Kind.LEQ, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final CalculationSymbol intEqualSymbol = new CalculationConstant("=", binaryIntComparisonType, CalculationSymbol.Kind.EQUALS, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final CalculationSymbol intDistinctSymbol = new CalculationConstant("\u2260", binaryIntComparisonType, CalculationSymbol.Kind.NEQ, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final CalculationSymbol stringEqualSymbol = new CalculationConstant("=", binaryStringComparisonType, CalculationSymbol.Kind.EQUALS, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final CalculationSymbol stringDistinctSymbol = new CalculationConstant("\u2260", binaryStringComparisonType, CalculationSymbol.Kind.NEQ, CalculationSymbol.Associativity.ASSOC_NONE, 3);
    public static final Value trueValue = new BooleanValue(true);
    public static final Value falseValue = new BooleanValue(false);
    public static final Value zeroValue = new IntegerValue(0);
    public static final Value emptyStringValue = new StringValue("");

    public static Variable createVar(String name, Base type) {
        if (!type.isTheoryType()) {
            throw new IllegalArgumentException("TheoryFactory::createVar is given type " + String.valueOf(type) + " which is not a theory sort.");
        }
        return new Var(name, type);
    }

    public static Variable createBoolVar(String name) {
        return new Var(name, TypeFactory.boolSort);
    }

    public static Variable createIntVar(String name) {
        return new Var(name, TypeFactory.intSort);
    }

    public static Value createValue(int n) {
        return new IntegerValue(n);
    }

    public static Value createValue(boolean b) {
        return new BooleanValue(b);
    }

    public static Value createValue(String s) {
        return new StringValue(s);
    }

    public static Value createEscapedStringValue(String s) throws IncorrectStringException {
        return StringValue.parseUserStringValue(s);
    }

    public static Term createEquality(Term a, Term b) {
        if (!a.queryType().equals(b.queryType())) {
            throw new IllegalArgumentException("TheoryFactory::createEquality received terms of two different types!");
        }
        if (a.queryType().equals(TypeFactory.boolSort)) {
            return new Application(iffSymbol, a, b);
        }
        if (a.queryType().equals(TypeFactory.intSort)) {
            return new Application(intEqualSymbol, a, b);
        }
        if (a.queryType().equals(TypeFactory.stringSort)) {
            return new Application(stringEqualSymbol, a, b);
        }
        throw new IllegalArgumentException("Cannot create an equality for terms of type " + a.queryType().toString());
    }

    public static Term createConjunction(Term a, Term b) {
        if (!a.queryType().equals(TypeFactory.boolSort) || !b.queryType().equals(TypeFactory.boolSort)) {
            throw new IllegalArgumentException("TheoryFactory::createConjunction called with arguments of type " + a.queryType().toString() + " and " + b.queryType().toString() + " respectively (expected booleans).");
        }
        if (a instanceof BooleanValue) {
            if (((BooleanValue)a).getBool()) {
                return b;
            }
            return a;
        }
        if (b instanceof BooleanValue) {
            if (((BooleanValue)b).getBool()) {
                return a;
            }
            return b;
        }
        return new Application(andSymbol, a, b);
    }

    public static LinkedHashSet<CalculationSymbol> queryAllCalculationSymbols() {
        LinkedHashSet<CalculationSymbol> set = new LinkedHashSet<CalculationSymbol>();
        set.add(plusSymbol);
        set.add(timesSymbol);
        set.add(minusSymbol);
        set.add(divSymbol);
        set.add(modSymbol);
        set.add(andSymbol);
        set.add(orSymbol);
        set.add(notSymbol);
        set.add(iffSymbol);
        set.add(xorSymbol);
        set.add(greaterSymbol);
        set.add(smallerSymbol);
        set.add(geqSymbol);
        set.add(leqSymbol);
        set.add(intEqualSymbol);
        set.add(intDistinctSymbol);
        set.add(stringEqualSymbol);
        set.add(stringDistinctSymbol);
        return set;
    }

    public static Value getNewIntValue(Set<Value> exclude) {
        if (!exclude.contains(zeroValue)) {
            return zeroValue;
        }
        int i = 1;
        while (true) {
            for (int j = 1; j > -2; j -= 2) {
                IntegerValue v = new IntegerValue(i * j);
                if (exclude.contains(v)) continue;
                return v;
            }
            ++i;
        }
    }

    public static Value getNewStringValue(Set<Value> exclude) {
        if (!exclude.contains(emptyStringValue)) {
            return emptyStringValue;
        }
        int i = 1;
        while (true) {
            StringValue v;
            StringBuilder builder = new StringBuilder();
            int k = ++i;
            while (k > 0) {
                builder.append((char)((k - 1) % 26 + 97));
                if (k <= 26) break;
                k = (k - 1) / 26;
            }
            if (exclude.contains(v = new StringValue(builder.toString()))) continue;
            return v;
        }
    }

    public static Value getNewValue(Base sort, Set<Value> exclude) {
        if (sort.equals(TypeFactory.boolSort)) {
            if (!exclude.contains(trueValue)) {
                return trueValue;
            }
            if (!exclude.contains(falseValue)) {
                return falseValue;
            }
            return null;
        }
        if (sort.equals(TypeFactory.intSort)) {
            return TheoryFactory.getNewIntValue(exclude);
        }
        if (sort.equals(TypeFactory.stringSort)) {
            return TheoryFactory.getNewStringValue(exclude);
        }
        return null;
    }
}

