/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.FunctionSymbol;
import charlie.terms.InappropriatePatternDataException;
import charlie.terms.InvalidPositionException;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermInherit;
import charlie.terms.Variable;
import charlie.terms.position.ArgumentPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.NullStorageException;
import charlie.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Tuple
extends TermInherit {
    private ArrayList<Term> _components;
    private Type _tupleType;

    private void buildTuple(List<Term> tms) {
        for (int i = 0; i < tms.size(); ++i) {
            if (tms.get(i) != null) continue;
            throw new NullStorageException("Tuple", "passing a null argument to Tuple constructor.");
        }
        this._components = new ArrayList();
        ReplaceableList empty = ReplaceableList.EMPTY;
        ReplaceableList frees = Tuple.calculateFreeReplaceablesForSubterms(tms, empty);
        ReplaceableList bounds = Tuple.calculateBoundVariablesAndRefreshSubs(tms, empty, frees, this._components);
        this.setVariables(frees, bounds);
        FixedList.Builder<Type> tmsTy = new FixedList.Builder<Type>();
        for (Term t : tms) {
            tmsTy.add(t.queryType());
        }
        this._tupleType = TypeFactory.createProduct(tmsTy.build());
    }

    Tuple(List<Term> tms) {
        if (tms == null) {
            throw new NullStorageException("Tuple", "components list");
        }
        if (tms.size() < 2) {
            throw new IllegalArgumentException("Tuple::constructor -- the provided list of terms has " + tms.size() + " elements.  However, tuples can only be created with at least two terms.");
        }
        this.buildTuple(tms);
    }

    Tuple(Term a, Term b) {
        ArrayList<Term> args = new ArrayList<Term>();
        args.add(a);
        args.add(b);
        this.buildTuple(args);
    }

    Tuple(Term a, Term b, Term c) {
        ArrayList<Term> args = new ArrayList<Term>();
        args.add(a);
        args.add(b);
        args.add(c);
        this.buildTuple(args);
    }

    @Override
    public Type queryType() {
        return this._tupleType;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public boolean isTheoryTerm() {
        return this._components.stream().allMatch(Term::isTheoryTerm);
    }

    @Override
    public void storeFunctionSymbols(Set<FunctionSymbol> storage) {
        for (Term t : this._components) {
            t.storeFunctionSymbols(storage);
        }
    }

    @Override
    public int numberTupleArguments() {
        return this._components.size();
    }

    @Override
    public ArrayList<Term> queryTupleArguments() {
        return new ArrayList<Term>(this._components);
    }

    @Override
    public Term queryTupleArgument(int i) {
        return this._components.get(i - 1);
    }

    @Override
    public Variable queryVariable() {
        throw new InappropriatePatternDataException("Tuple", "queryRoot", "a varterm, abstraction or beta-redex.");
    }

    @Override
    public MetaVariable queryMetaVariable() {
        throw new InappropriatePatternDataException("Tuple", "queryRoot", "a functional term of the form f(s1, ..., sn).");
    }

    @Override
    public boolean isFirstOrder() {
        return this._components.stream().allMatch(Term::isFirstOrder);
    }

    @Override
    public boolean isPattern() {
        return this._components.stream().allMatch(Term::isPattern);
    }

    @Override
    public boolean isSemiPattern() {
        return this._components.stream().allMatch(Term::isSemiPattern);
    }

    @Override
    public boolean isApplicative() {
        return this._components.stream().allMatch(Term::isApplicative);
    }

    @Override
    public List<Pair<Term, Position>> querySubterms() {
        ArrayList<Pair<Term, Position>> ret = new ArrayList<Pair<Term, Position>>();
        for (int i = 0; i < this._components.size(); ++i) {
            List<Pair<Term, Position>> subs = this._components.get(i).querySubterms();
            for (Pair<Term, Position> pair : subs) {
                ret.add(new Pair<Term, ArgumentPos>(pair.fst(), new ArgumentPos(i + 1, pair.snd())));
            }
        }
        ret.add(new Pair<Tuple, Position>(this, Position.empty));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Term querySubtermMain(Position pos) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArgumentPos.class}, (Object)position2, n)) {
            case 0: {
                ArgumentPos argumentPos = (ArgumentPos)position2;
                try {
                    Position position3;
                    int n2;
                    int index = n2 = argumentPos.index();
                    Position tail = position3 = argumentPos.tail();
                    if (index > this._components.size()) throw new InvalidPositionException(this, pos, "querying subterm of tuple");
                    return this._components.get(index - 1).querySubterm(tail);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new InvalidPositionException(this, pos, "querying subterm of tuple");
    }

    /*
     * Loose catch block
     */
    @Override
    public Term replaceSubtermMain(Position pos, Term replacement) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArgumentPos.class}, (Object)position2, n)) {
            case 0: {
                Position position3;
                int n2;
                ArgumentPos argumentPos = (ArgumentPos)position2;
                int index = n2 = argumentPos.index();
                Position tail = position3 = argumentPos.tail();
                if (index > this._components.size()) break;
                Term tmp = this._components.get(index - 1);
                this._components.set(index - 1, tmp.replaceSubterm(tail, replacement));
                Tuple ret = new Tuple(this._components);
                this._components.set(index - 1, tmp);
                return ret;
            }
        }
        throw new InvalidPositionException(this, pos, "replacing subterm of tuple");
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    public Term renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        ArrayList<Term> parts = new ArrayList<Term>(this._components);
        boolean changed = false;
        for (int i = 0; i < parts.size(); ++i) {
            Term other = parts.get(i).renameAndRefreshBinders(renaming);
            if (other == parts.get(i)) continue;
            changed = true;
            parts.set(i, other);
        }
        if (!changed) {
            return this;
        }
        return new Tuple(parts);
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        if (!term.isTuple() || !this._tupleType.equals(term.queryType())) {
            return false;
        }
        if (this._components.size() != term.numberTupleArguments()) {
            return false;
        }
        for (int i = 0; i < this._components.size(); ++i) {
            if (this._components.get(i).alphaEquals(term.queryTupleArgument(i + 1), mu, xi, k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        int ret = 0;
        for (int i = 0; i < this._components.size(); ++i) {
            ret += 31 * ret + this._components.get(i).hashCode(mu);
        }
        return ret;
    }
}

