/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.LeafTermInherit;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.terms.replaceable.ReplaceableList;
import charlie.types.Type;
import charlie.util.NullStorageException;
import java.util.Map;

final class Var
extends LeafTermInherit
implements Variable,
MetaVariable {
    private static int COUNTER = 0;
    private final String _name;
    private final int _index;

    Var(String name, Type type) {
        super(type);
        this._name = name;
        this._index = COUNTER++;
        if (name == null) {
            throw new NullStorageException("Var", "name");
        }
        this.setVariables(new ReplaceableList(this));
    }

    Var(Type type) {
        super(type);
        this._name = "X";
        this._index = COUNTER++;
        this.setVariables(new ReplaceableList(this));
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    @Override
    public boolean isVarTerm() {
        return true;
    }

    @Override
    public boolean isMetaApplication() {
        return true;
    }

    @Override
    public boolean isBinderVariable() {
        return false;
    }

    @Override
    public boolean isApplicative() {
        return true;
    }

    @Override
    public boolean isTheoryTerm() {
        return this.queryType().isTheoryType();
    }

    @Override
    public int queryArity() {
        return 0;
    }

    @Override
    public boolean isFirstOrder() {
        return this.queryType().isBaseType();
    }

    @Override
    public String queryName() {
        return this._name;
    }

    @Override
    public int queryIndex() {
        return this._index;
    }

    @Override
    public Replaceable.Kind queryReplaceableKind() {
        return Replaceable.Kind.BASEVAR;
    }

    @Override
    public Type queryOutputType() {
        return this.queryType();
    }

    @Override
    public Type queryInputType(int index) {
        throw new IndexOutOfBoundsException("Var::queryInputType(" + index + ") called");
    }

    @Override
    public Variable queryVariable() {
        return this;
    }

    @Override
    public MetaVariable queryMetaVariable() {
        return this;
    }

    public Term makeTerm() {
        return this;
    }

    @Override
    public boolean equals(Variable other) {
        return other == this;
    }

    @Override
    public boolean equals(Replaceable other) {
        return other == this;
    }

    @Override
    public Var renameAndRefreshBinders(Map<Variable, Variable> renaming) {
        return this;
    }

    @Override
    public boolean alphaEquals(Term term, Map<Variable, Integer> mu, Map<Variable, Integer> xi, int k) {
        return term.isVariable() && this.equals(term.queryVariable());
    }

    @Override
    public int compareTo(Replaceable other) {
        if (other == this) {
            return 0;
        }
        int d = other.queryReplaceableKind().compareTo(this.queryReplaceableKind());
        if (d != 0) {
            return d;
        }
        if (this._index < other.queryIndex()) {
            return -1;
        }
        if (this._index > other.queryIndex()) {
            return 1;
        }
        return this.queryType().toString().compareTo(other.queryType().toString());
    }

    @Override
    public int hashCode(Map<Variable, Integer> mu) {
        return 3 * this._index;
    }
}

