/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms;

import charlie.terms.Environment;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.terms.replaceable.ReplaceableList;
import java.util.Iterator;
import java.util.NoSuchElementException;

class VariableEnvironment
implements Environment<Variable> {
    private final ReplaceableList _lst;

    VariableEnvironment(ReplaceableList lst) {
        this._lst = lst;
    }

    @Override
    public boolean contains(Variable x) {
        return this._lst.contains(x);
    }

    @Override
    public int size() {
        int counter = 0;
        for (Variable x : this) {
            ++counter;
        }
        return counter;
    }

    @Override
    public Iterator<Variable> iterator() {
        return new Iterator<Variable>(){
            private final Iterator<Replaceable> lstIterator;
            private Variable nxt;
            {
                this.lstIterator = VariableEnvironment.this._lst.iterator();
                this.nxt = null;
            }

            private void loadNext() {
                while (this.nxt == null && this.lstIterator.hasNext()) {
                    Replaceable n = this.lstIterator.next();
                    if (!(n instanceof Variable)) continue;
                    this.nxt = (Variable)n;
                }
            }

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.nxt != null;
            }

            @Override
            public Variable next() {
                this.loadNext();
                if (this.nxt == null) {
                    throw new NoSuchElementException();
                }
                Variable ret = this.nxt;
                this.nxt = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

