/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms.position;

import charlie.terms.position.Position;
import charlie.util.NullStorageException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public record ArgumentPos(int index, Position tail) implements Position
{
    public ArgumentPos {
        if (index <= 0) {
            throw new IllegalArgumentException("ArgumentPos::constructor -- given index \u2264 0");
        }
        if (tail == null) {
            throw new NullStorageException("ArgumentPos", "tail");
        }
    }

    @Override
    public String toString() {
        return this.toStringDefault();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Position other) {
        Position position = other;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArgumentPos.class}, (Object)position2, n)) {
            case 0: {
                ArgumentPos argumentPos = (ArgumentPos)position2;
                try {
                    Position position3;
                    int n2;
                    int id = n2 = argumentPos.index();
                    Position tl = position3 = argumentPos.tail();
                    if (this.index != id) return false;
                    if (!this.tail.equals(tl)) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Position) {
            Position p = (Position)other;
            return this.equals(p);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 7 * this.tail.hashCode() + this.index;
    }

    @Override
    public Position append(Position p) {
        return new ArgumentPos(this.index, this.tail.append(p));
    }

    @Override
    public int queryChopCount() {
        return this.tail.queryChopCount();
    }

    @Override
    public int compareTo(Position other) {
        if (other.isFinal()) {
            return 1;
        }
        int c = this.index - other.queryHead();
        if (c != 0) {
            return c;
        }
        return this.tail.compareTo(other.queryTail());
    }

    @Override
    public int queryHead() {
        return this.index;
    }

    @Override
    public Position queryTail() {
        return this.tail;
    }
}

