/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms.position;

import charlie.terms.position.Position;
import charlie.util.NullStorageException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public record LambdaPos(Position tail) implements Position
{
    public LambdaPos {
        if (tail == null) {
            throw new NullStorageException("LambdaPos", "tail");
        }
    }

    @Override
    public String toString() {
        return this.toStringDefault();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Position other) {
        Position position = other;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LambdaPos.class}, (Object)position2, n)) {
            case 0: {
                LambdaPos lambdaPos = (LambdaPos)position2;
                try {
                    Position position3;
                    Position tl = position3 = lambdaPos.tail();
                    return this.tail.equals(tl);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Position) {
            Position p = (Position)other;
            return this.equals(p);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 7 * this.tail.hashCode();
    }

    @Override
    public Position append(Position p) {
        return new LambdaPos(this.tail.append(p));
    }

    @Override
    public int queryChopCount() {
        return this.tail.queryChopCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Position other) {
        Position t;
        if (other.isFinal()) {
            return 1;
        }
        if (!(other instanceof LambdaPos)) return -other.queryHead();
        LambdaPos lambdaPos = (LambdaPos)other;
        try {
            Position position;
            t = position = lambdaPos.tail();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return this.tail.compareTo(t);
    }

    @Override
    public int queryHead() {
        return 0;
    }

    @Override
    public Position queryTail() {
        return this.tail;
    }
}

