/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms.position;

import charlie.terms.position.Position;
import charlie.util.NullStorageException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public record MetaPos(int index, Position tail) implements Position
{
    public MetaPos {
        if (index <= 0) {
            throw new IllegalArgumentException("MetaPos::constructor -- given index \u2264 0");
        }
        if (tail == null) {
            throw new NullStorageException("MetaPos", "tail");
        }
    }

    @Override
    public String toString() {
        return this.toStringDefault();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Position other) {
        Position position = other;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetaPos.class}, (Object)position2, n)) {
            case 0: {
                MetaPos metaPos = (MetaPos)position2;
                try {
                    Position position3;
                    int n2;
                    int id = n2 = metaPos.index();
                    Position tl = position3 = metaPos.tail();
                    if (this.index != id) return false;
                    if (!this.tail.equals(tl)) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Position) {
            Position p = (Position)other;
            return this.equals(p);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 7 * this.tail.hashCode() + this.index;
    }

    @Override
    public Position append(Position p) {
        return new MetaPos(this.index, this.tail.append(p));
    }

    @Override
    public int queryChopCount() {
        return this.tail.queryChopCount();
    }

    @Override
    public int compareTo(Position pos) {
        if (pos.isFinal()) {
            return 1;
        }
        int c = this.queryHead() - pos.queryHead();
        if (c != 0) {
            return c;
        }
        return this.tail.compareTo(pos.queryTail());
    }

    @Override
    public int queryHead() {
        return -this.index;
    }

    @Override
    public Position queryTail() {
        return this.tail;
    }
}

