/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms.position;

import charlie.terms.position.ArgumentPos;
import charlie.terms.position.FinalPos;
import charlie.terms.position.LambdaPos;
import charlie.terms.position.MetaPos;
import charlie.terms.position.PositionFormatException;
import charlie.terms.position.PositionPrinter;
import java.util.Iterator;
import java.util.LinkedList;

public sealed interface Position
extends Comparable<Position>
permits FinalPos, ArgumentPos, LambdaPos, MetaPos {
    public static final Position empty = new FinalPos(0);

    public boolean equals(Position var1);

    default public String toStringDefault() {
        return new PositionPrinter().print(this);
    }

    public Position append(Position var1);

    default public boolean isEmpty() {
        return false;
    }

    default public boolean isFinal() {
        return false;
    }

    public int queryChopCount();

    public int queryHead();

    public Position queryTail();

    public static Position parse(String text) throws PositionFormatException {
        Object ret;
        int n;
        if (text.equals("")) {
            return empty;
        }
        int chp = 0;
        int star = text.indexOf(9734);
        if (star == -1) {
            star = text.indexOf(42);
        }
        if (star != -1) {
            try {
                chp = Integer.parseInt(text.substring(star + 1));
            }
            catch (NumberFormatException ex) {
                throw new PositionFormatException(star + 1, text, "chop count should be an integer, but instead is [" + text.substring(star + 1) + "].");
            }
            n = star;
        } else {
            n = text.charAt(text.length() - 1) == '\u03b5' ? text.length() - 1 : (text.charAt(text.length() - 1) == 'e' ? text.length() - 1 : text.length());
        }
        if (n > 0 && text.charAt(n - 1) == '.') {
            --n;
        }
        Position position = ret = chp == 0 ? empty : new FinalPos(chp);
        while (n > 0) {
            int num;
            int dot = text.lastIndexOf(46, n - 1);
            if (dot == n - 1) {
                throw new PositionFormatException(dot + 1, text, "empty position index");
            }
            String part = text.substring(dot + 1, n);
            boolean meta = false;
            if (part.length() > 0 && part.charAt(0) == '!') {
                meta = true;
                part = part.substring(1);
            }
            try {
                num = Integer.parseInt(part);
            }
            catch (NumberFormatException ex) {
                throw new PositionFormatException(dot + 1, text, "position index should be an integer, but instead is [" + part + "].");
            }
            if (num < 0) {
                meta = true;
                num = -num;
            }
            ret = meta ? new MetaPos(num, (Position)ret) : (num == 0 ? new LambdaPos((Position)ret) : new ArgumentPos(num, (Position)ret));
            n = dot;
        }
        return ret;
    }

    public static Position of(LinkedList<Integer> indexes) {
        return Position.of(indexes, empty);
    }

    public static Position of(LinkedList<Integer> indexes, Position ending) {
        Position p = ending;
        Iterator<Integer> iterator = indexes.descendingIterator();
        while (iterator.hasNext()) {
            int k = iterator.next();
            if (k > 0) {
                p = new ArgumentPos(k, p);
                continue;
            }
            if (k < 0) {
                p = new MetaPos(-k, p);
                continue;
            }
            p = new LambdaPos(p);
        }
        return p;
    }
}

