/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms.position;

import charlie.terms.position.ArgumentPos;
import charlie.terms.position.FinalPos;
import charlie.terms.position.LambdaPos;
import charlie.terms.position.MetaPos;
import charlie.terms.position.Position;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class PositionPrinter {
    public final String print(Position pos) {
        StringBuilder builder = new StringBuilder();
        this.print(pos, builder);
        return builder.toString();
    }

    public void print(Position pos, StringBuilder builder) {
        Position position = pos;
        Objects.requireNonNull(position);
        Position position2 = position;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FinalPos.class, ArgumentPos.class, LambdaPos.class, MetaPos.class}, (Object)position2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int n2;
                FinalPos finalPos = (FinalPos)position2;
                int chopcount = n2 = finalPos.chopcount();
                if (chopcount == 0) {
                    this.printEmptyPos(builder);
                    break;
                }
                this.printChopPos(chopcount, builder);
                break;
            }
            case 1: {
                Position position3;
                int n3;
                ArgumentPos argumentPos = (ArgumentPos)position2;
                int index = n3 = argumentPos.index();
                Position tail = position3 = argumentPos.tail();
                this.printArgumentPos(index, builder);
                this.printTail(tail, builder);
                break;
            }
            case 2: {
                Position position4;
                LambdaPos lambdaPos = (LambdaPos)position2;
                Position tail = position4 = lambdaPos.tail();
                this.printLambdaPos(builder);
                this.printTail(tail, builder);
                break;
            }
            case 3: {
                Position position5;
                int index;
                MetaPos metaPos = (MetaPos)position2;
                try {
                    int n4;
                    index = n4 = metaPos.index();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Position tail = position5 = metaPos.tail();
                this.printMetaPos(index, builder);
                this.printTail(tail, builder);
                break;
            }
        }
    }

    protected void printEmptyPos(StringBuilder builder) {
        builder.append(this.queryEmptyPositionSymbol());
    }

    protected void printChopPos(int chopcount, StringBuilder builder) {
        builder.append(this.queryChopSymbol() + chopcount);
    }

    protected void printTail(Position tail, StringBuilder builder) {
        if (!tail.isEmpty()) {
            builder.append(this.queryCompositeSymbol());
            this.print(tail, builder);
        }
    }

    protected void printArgumentPos(int index, StringBuilder builder) {
        builder.append("" + index);
    }

    protected void printLambdaPos(StringBuilder builder) {
        builder.append("0");
    }

    protected void printMetaPos(int index, StringBuilder builder) {
        builder.append("!" + index);
    }

    protected String queryEmptyPositionSymbol() {
        return "\u03b5";
    }

    protected String queryChopSymbol() {
        return "\u2606";
    }

    protected String queryCompositeSymbol() {
        return ".";
    }
}

